/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.emptyoperator;

import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.NameValuePair;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private final boolean[] deferred = new boolean[]{true, false};

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elEmptyNullTest() throws Exception {
        boolean pass = false;
        String[] symbols = new String[]{"$", "#"};
        boolean expectedResult = true;
        try {
            for (String prefix : symbols) {
                String expr = prefix + "{empty null}";
                Object result = ExprEval.evaluateValueExpression(expr, null, Object.class);
                if (result == null) {
                    logger.log(System.Logger.Level.TRACE, "result is null");
                } else {
                    logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                }
                boolean bl = pass = ExprEval.compareClass(result, Boolean.class) && ExprEval.compareValue((Boolean)result, expectedResult);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Test
    public void elEmptyStringTest() throws Exception {
        this.testEmptyOperator("", true);
        this.testEmptyOperator("something", false);
    }

    @Test
    public void elEmptyArrayTest() throws Exception {
        this.testEmptyOperator(new String[0], true);
        String[] testArray = new String[]{"Apple"};
        this.testEmptyOperator(testArray, false);
    }

    @Test
    public void elEmptyMapTest() throws Exception {
        HashMap<String, String> testMap = new HashMap<String, String>();
        this.testEmptyOperator(testMap, true);
        testMap.put("Fruit", "Apple");
        this.testEmptyOperator(testMap, false);
        testMap.clear();
    }

    @Test
    public void elEmptyCollectionTest() throws Exception {
        ArrayList<String> testCollection = new ArrayList<String>();
        this.testEmptyOperator(testCollection, true);
        testCollection.add("Apple");
        this.testEmptyOperator(testCollection, false);
        testCollection.clear();
    }

    private void testEmptyOperator(Object testVal, boolean expectedResult) throws Exception {
        boolean pass = false;
        NameValuePair[] value = NameValuePair.buildUnaryNameValue(testVal);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "empty");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                boolean bl = pass = ExprEval.compareClass(result, Boolean.class) && ExprEval.compareValue((Boolean)result, expectedResult);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

