/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.semicolonoperator;

import com.sun.ts.tests.el.common.util.TypesBean;
import com.sun.ts.tests.el.common.util.Validator;
import jakarta.el.ELProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elSemiColonOperatorBigDecimalTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "BigDecimal";
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            elp.eval(bValue);
            Validator.testExpression(elp, "a = types.tckBigDecimal; a + b", BigDecimal.valueOf(2L), comparitorA + " + " + bName);
            Validator.testExpression(elp, "a = types.tckBigDecimal; a * b", BigDecimal.valueOf(1L), comparitorA + " * " + bName);
            Validator.testExpression(elp, "a = types.tckBigDecimal; a - b", BigDecimal.valueOf(0L), comparitorA + " - " + bName);
            Validator.testExpression(elp, "a = types.tckBigDecimal; a / b", BigDecimal.valueOf(1L), comparitorA + " / " + bName);
            Validator.testExpression(elp, "a = types.tckBigDecimal; a div b", BigDecimal.valueOf(1L), comparitorA + " div " + bName);
            Validator.testExpression(elp, "a = types.tckBigDecimal; a % b", 0.0, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a = types.tckBigDecimal; a mod b", 0.0, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elSemiColonOperatorFloatTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Float";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.TRACE, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            elp.eval(bValue);
            if ("BigInteger".equals(bName)) {
                Validator.testExpression(elp, "a = types.tckFloat; a + b", BigDecimal.valueOf(2L), comparitorA + " + " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a * b", BigDecimal.valueOf(1L), comparitorA + " * " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a - b", BigDecimal.valueOf(0L), comparitorA + " - " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a / b", BigDecimal.valueOf(1L), comparitorA + " / " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a div b", BigDecimal.valueOf(1L), comparitorA + " div " + bName);
            } else {
                Validator.testExpression(elp, "a = types.tckFloat; a + b", 2.0, comparitorA + " + " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a * b", 1.0, comparitorA + " * " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a - b", 0.0, comparitorA + " - " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a / b", 1.0, comparitorA + " / " + bName);
                Validator.testExpression(elp, "a = types.tckFloat; a div b", 1.0, comparitorA + " div " + bName);
            }
            Validator.testExpression(elp, "a = types.tckFloat; a % b", 0.0, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a = types.tckFloat; a mod b", 0.0, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elSemiColonOperatorDoubleTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Double";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("Float");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.TRACE, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            elp.eval(bValue);
            if ("BigInteger".equals(bName)) {
                Validator.testExpression(elp, "a = types.tckDouble; a + b", BigDecimal.valueOf(2L), comparitorA + " + " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a * b", BigDecimal.valueOf(1L), comparitorA + " * " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a - b", BigDecimal.valueOf(0L), comparitorA + " - " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a / b", BigDecimal.valueOf(1L), comparitorA + " / " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a div b", BigDecimal.valueOf(1L), comparitorA + " div " + bName);
            } else {
                Validator.testExpression(elp, "a = types.tckDouble; a + b", 2.0, comparitorA + " + " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a * b", 1.0, comparitorA + " * " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a - b", 0.0, comparitorA + " - " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a / b", 1.0, comparitorA + " / " + bName);
                Validator.testExpression(elp, "a = types.tckDouble; a div b", 1.0, comparitorA + " div " + bName);
            }
            Validator.testExpression(elp, "a = types.tckDouble; a % b", 0.0, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a = types.tckDouble; a mod b", 0.0, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elSemiColonOperatorBigIntegerTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "BigInteger";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("Double");
        excludeList.add("Float");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.TRACE, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            elp.eval(bValue);
            Validator.testExpression(elp, "a = types.tckBigInteger; a + b", BigInteger.valueOf(2L), comparitorA + " + " + bName);
            Validator.testExpression(elp, "a = types.tckBigInteger; a * b", BigInteger.valueOf(1L), comparitorA + " * " + bName);
            Validator.testExpression(elp, "a = types.tckBigInteger; a - b", BigInteger.valueOf(0L), comparitorA + " - " + bName);
            Validator.testExpression(elp, "a = types.tckBigInteger; a / b", BigDecimal.valueOf(1L), comparitorA + " / " + bName);
            Validator.testExpression(elp, "a = types.tckBigInteger; a div b", BigDecimal.valueOf(1L), comparitorA + " div " + bName);
            Validator.testExpression(elp, "a = types.tckBigInteger; a % b", BigInteger.valueOf(0L), comparitorA + " % " + bName);
            Validator.testExpression(elp, "a = types.tckBigInteger; a mod b", BigInteger.valueOf(0L), comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elSemiColonOperatorIntegerTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Integer";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Double");
        excludeList.add("Float");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.TRACE, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            elp.eval(bValue);
            Validator.testExpression(elp, "a = types.tckInteger; a + b", 2L, comparitorA + " + " + bName);
            Validator.testExpression(elp, "a = types.tckInteger; a * b", 1L, comparitorA + " * " + bName);
            Validator.testExpression(elp, "a = types.tckInteger; a - b", 0L, comparitorA + " - " + bName);
            Validator.testExpression(elp, "a = types.tckInteger; a / b", 1.0, comparitorA + " / " + bName);
            Validator.testExpression(elp, "a = types.tckInteger; a div b", 1.0, comparitorA + " div " + bName);
            Validator.testExpression(elp, "a = types.tckInteger; a % b", 0L, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a = types.tckInteger; a mod b", 0L, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elSemiColonOperatorLongTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Long";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.TRACE, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            elp.eval(bValue);
            Validator.testExpression(elp, "a = types.tckLong; a + b", 2L, comparitorA + " + " + bName);
            Validator.testExpression(elp, "a = types.tckLong; a * b", 1L, comparitorA + " * " + bName);
            Validator.testExpression(elp, "a = types.tckLong; a - b", 0L, comparitorA + " - " + bName);
            Validator.testExpression(elp, "a = types.tckLong; a / b", 1.0, comparitorA + " / " + bName);
            Validator.testExpression(elp, "a = types.tckLong; a div b", 1.0, comparitorA + " div " + bName);
            Validator.testExpression(elp, "a = types.tckLong; a % b", 0L, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a = types.tckLong; a mod b", 0L, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elSemiColonOperatorShortTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Short";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        excludeList.add("Long");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.TRACE, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            elp.eval(bValue);
            Validator.testExpression(elp, "a = types.tckShort; a + b", 2L, comparitorA + " + " + bName);
            Validator.testExpression(elp, "a = types.tckShort; a * b", 1L, comparitorA + " * " + bName);
            Validator.testExpression(elp, "a = types.tckShort; a - b", 0L, comparitorA + " - " + bName);
            Validator.testExpression(elp, "a = types.tckShort; a / b", 1.0, comparitorA + " / " + bName);
            Validator.testExpression(elp, "a = types.tckShort; a div b", 1.0, comparitorA + " div " + bName);
            Validator.testExpression(elp, "a = types.tckShort; a % b", 0L, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a mod b", 0L, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elSemiColonOperatorByteTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        String comparitorA = "Byte";
        ArrayList<String> excludeList = new ArrayList<String>();
        excludeList.add("BigDecimal");
        excludeList.add("BigInteger");
        excludeList.add("Integer");
        excludeList.add("Double");
        excludeList.add("Float");
        excludeList.add("Long");
        excludeList.add("Short");
        elp.defineBean("types", (Object)new TypesBean());
        for (Class<?> bType : TypesBean.getNumberMap().keySet()) {
            String bValue = TypesBean.getNumberMap().get(bType);
            String bName = bType.getSimpleName();
            if (excludeList.contains(bName)) {
                logger.log(System.Logger.Level.TRACE, "*** Skipping " + comparitorA + " with " + bName + ", Already Tested in " + bName + " Test Sequence ***");
                continue;
            }
            elp.eval(bValue);
            Validator.testExpression(elp, "a = types.tckByte; a + b", 2L, comparitorA + " + " + bName);
            Validator.testExpression(elp, "a = types.tckByte; a * b", 1L, comparitorA + " * " + bName);
            Validator.testExpression(elp, "a = types.tckByte; a - b", 0L, comparitorA + " - " + bName);
            Validator.testExpression(elp, "a = types.tckByte; a / b", 1.0, comparitorA + " / " + bName);
            Validator.testExpression(elp, "a = types.tckByte; a div b", 1.0, comparitorA + " div " + bName);
            Validator.testExpression(elp, "a = types.tckByte; a % b", 0L, comparitorA + " % " + bName);
            Validator.testExpression(elp, "a = types.tckByte; a mod b", 0L, comparitorA + " mod " + bName);
            elp.eval("a = null");
            elp.eval("b = null");
        }
    }

    @Test
    public void elSemiColonOperatorNullTest() throws Exception {
        ELProcessor elp = new ELProcessor();
        elp.defineBean("types", (Object)new TypesBean());
        Long expected = 0L;
        String bValue = "b = types.tckNull";
        elp.eval(bValue);
        Validator.testExpression(elp, "a = null; a + b", expected, "null + null");
        Validator.testExpression(elp, "a = null; a - b", expected, "null - null");
        Validator.testExpression(elp, "a = null; a * b", expected, "null * null");
        Validator.testExpression(elp, "a = null; a / b", expected, "null / null");
        Validator.testExpression(elp, "a = null; a div b", expected, "null div null");
        Validator.testExpression(elp, "a = null; a % b", expected, "null % null");
        Validator.testExpression(elp, "a = null; a mod b", expected, "null mod null");
    }
}

