/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.elresolver;

import com.sun.ts.tests.el.common.api.resolver.ResolverTest;
import com.sun.ts.tests.el.common.elcontext.BarELContext;
import com.sun.ts.tests.el.common.util.SimpleBean;
import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELManager;
import jakarta.el.ELResolver;
import jakarta.el.StandardELContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private static final String[] names = new String[]{"doug", "nick", "roger", "ryan", "ed"};

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elResolverTest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        try {
            BarELContext barContext = new BarELContext();
            ELContext context = barContext.getELContext();
            if (barContext != null) {
                ELResolver resolver = barContext.getELResolver();
                pass = ResolverTest.testELResolver(context, resolver, null, "Bar", "Foo", buf, true);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void elResolverNPETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        StandardELContext context = new ELManager().getELContext();
        ArrayELResolver aResolver = new ArrayELResolver();
        BeanELResolver bResolver = new BeanELResolver();
        CompositeELResolver compResolver = (CompositeELResolver)context.getELResolver();
        compResolver.add((ELResolver)aResolver);
        compResolver.add((ELResolver)bResolver);
        try {
            pass = ResolverTest.testELResolverNPE((ELResolver)compResolver, names, 2, "steve", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void elResolverPNFETest() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        StandardELContext context = new ELManager().getELContext();
        ArrayELResolver aResolver = new ArrayELResolver();
        CompositeELResolver compResolver = (CompositeELResolver)context.getELResolver();
        compResolver.add((ELResolver)aResolver);
        try {
            pass = ResolverTest.testELResolverPNFE((ELContext)context, (ELResolver)compResolver, names, 10, buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void elResolverPNWETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        SimpleBean sb = new SimpleBean();
        StandardELContext context = new ELManager().getELContext();
        BeanELResolver resolver = new BeanELResolver(true);
        CompositeELResolver compResolver = (CompositeELResolver)context.getELResolver();
        compResolver.add((ELResolver)resolver);
        try {
            pass = ResolverTest.testELResolverPNWE((ELContext)context, (ELResolver)resolver, sb, "intention", "billy", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }
}

