/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.tagfileinfo;

import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.tagfileinfo.TagFileInfoTEI;
import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.tags.tck.SimpleTag;
import ee.jakarta.tck.pages.common.util.BaseTCKExtraInfo;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_taginfo_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_tagfileinfo_web.war");
        archive.addClasses(new Class[]{TagFileInfoTEI.class, JspTestUtil.class, BaseTCKExtraInfo.class, SimpleTag.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_tagfileinfo_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tagfileinfo.tld", "tagfileinfo.tld");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/tagfileinfo/TagFile1.tag", "tags/tagfileinfo/TagFile1.tag");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/GetNameTest.jsp")), "GetNameTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/GetPathTest.jsp")), "GetPathTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/GetTagInfoTest.jsp")), "GetTagInfoTest.jsp");
        return archive;
    }

    @Test
    public void tagFileInfoGetNameTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfileinfo_web/GetNameTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED.");
        this.invoke();
    }

    @Test
    public void tagFileInfoGetPathTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfileinfo_web/GetPathTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED.");
        this.invoke();
    }

    @Test
    public void tagFileInfoGetTagInfoTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfileinfo_web/GetTagInfoTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED.");
        this.invoke();
    }
}

