/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.configuration.charsequence;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import ee.jakarta.tck.pages.spec.configuration.charsequence.DeferredSyntaxAllowedAsLiteralTag;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    private static final String CONTEXT_ROOT = "/jsp_config_charsequence_web";
    public static String packagePath = URLClientIT.class.getPackageName().replace(".", "/");

    public URLClientIT() throws Exception {
        this.setGeneralURI("/jsp/spec/configuration/charsequence");
        this.setContextRoot(CONTEXT_ROOT);
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_config_charsequence_web.war");
        archive.addClasses(new Class[]{DeferredSyntaxAllowedAsLiteralTag.class, JspTestUtil.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_config_charsequence_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/config_charsequence.tld", "config_charsequence.tld");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/noDeferredSyntaxAllowedAsLiteralTemplateTextTest.jsp")), "noDeferredSyntaxAllowedAsLiteralTemplateTextTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/noDeferredSyntaxAllowedAsLiteralActionTest.jsp")), "noDeferredSyntaxAllowedAsLiteralActionTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/deferredSyntaxAllowedAsLiteralTrueTemplateTextTest.jsp")), "deferredSyntaxAllowedAsLiteralTrueTemplateTextTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/deferredSyntaxAllowedAsLiteralTrueActionTest.jsp")), "deferredSyntaxAllowedAsLiteralTrueActionTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/deferredSyntaxAllowedAsLiteralFalseTemplateTextTest.jsp")), "deferredSyntaxAllowedAsLiteralFalseTemplateTextTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/deferredSyntaxAllowedAsLiteralFalseActionTest.jsp")), "deferredSyntaxAllowedAsLiteralFalseActionTest.jsp");
        return archive;
    }

    @Test
    public void deferredSyntaxAllowedAsLiteralTrueTemplateTextTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/deferredSyntaxAllowedAsLiteralTrueTemplateTextTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "deferredSyntaxAllowedAsLiteralTrueTemplateTextTest");
        this.invoke();
    }

    @Test
    public void deferredSyntaxAllowedAsLiteralFalseTemplateTextTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_charsequence_web/deferredSyntaxAllowedAsLiteralFalseTemplateTextTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void deferredSyntaxAllowedAsLiteralTrueActionTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/deferredSyntaxAllowedAsLiteralTrueActionTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "deferredSyntaxAllowedAsLiteralTrueActionTest");
        this.invoke();
    }

    @Test
    public void deferredSyntaxAllowedAsLiteralFalseActionTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/deferredSyntaxAllowedAsLiteralTrueTemplateTextTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("request", "GET /jsp_config_charsequence_web/deferredSyntaxAllowedAsLiteralFalseActionTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void noDeferredSyntaxAllowedAsLiteralTemplateTextTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_charsequence_web/noDeferredSyntaxAllowedAsLiteralTemplateTextTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void noDeferredSyntaxAllowedAsLiteralActionTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_charsequence_web/noDeferredSyntaxAllowedAsLiteralActionTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }
}

