/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.core_syntax.actions.include;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    private static final String CONTEXT_ROOT = "/jsp_coresyntx_act_include_web";
    public static String packagePath = URLClientIT.class.getPackageName().replace(".", "/");

    public URLClientIT() throws Exception {
        this.setGeneralURI("/jsp/spec/core_syntax/actions/include");
        this.setContextRoot(CONTEXT_ROOT);
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_coresyntx_act_include_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_coresyntx_act_include_web.xml"));
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/staticStatic_A.jsp")), "staticStatic_A.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/staticDynamic_A.jsp")), "staticDynamic_A.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveRequestAttrPageRelative.jsp")), "positiveRequestAttrPageRelative.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveRequestAttrCtxRelative.jsp")), "positiveRequestAttrCtxRelative.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveIncludePageRelativeHtml.jsp")), "positiveIncludePageRelativeHtml.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveIncludePageRelative2.jsp")), "positiveIncludePageRelative2.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveIncludePageRelative.jsp")), "positiveIncludePageRelative.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveIncludeForward.jsp")), "positiveIncludeForward.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveIncludeCtxRelativeHtml.jsp")), "positiveIncludeCtxRelativeHtml.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveIncludeCtxRelative.jsp")), "positiveIncludeCtxRelative.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/includeMappedServletTest.jsp")), "includeMappedServletTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/includeforward.jsp")), "includeforward.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/includecommon.jsp")), "includecommon.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/includecommon.html")), "includecommon.html");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/forwardtarget.html")), "forwardtarget.html");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/dynamicStatic_A.jsp")), "dynamicStatic_A.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/dynamicDynamic_A.jsp")), "dynamicDynamic_A.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/C.jsp")), "C.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/include/static_B.jsp")), "include/static_B.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/include/includeMappedServlet.jsp")), "include/includeMappedServlet.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/include/includeMappedServlet.html")), "include/includeMappedServlet.html");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/include/include2.jsp")), "include/include2.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/include/dynamic_B.jsp")), "include/dynamic_B.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/include/C.jsp")), "include/C.jsp");
        return archive;
    }

    @Test
    public void positiveIncludeCtxRelativeTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveIncludeCtxRelative.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveIncludeCtxRelative");
        this.invoke();
    }

    @Test
    public void positiveIncludeCtxRelativeHtmlTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveIncludeCtxRelativeHtml.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveIncludeCtxRelativeHtml");
        this.invoke();
    }

    @Test
    public void positiveIncludePageRelativeTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveIncludePageRelative.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveIncludePageRelative");
        this.invoke();
    }

    @Test
    public void positiveRequestAttrCtxRelativeTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveRequestAttrCtxRelative.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveRequestAttrCtxRelative");
        this.invoke();
    }

    @Test
    public void positiveRequestAttrPageRelativeTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveRequestAttrPageRelative.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveRequestAttrPageRelative");
        this.invoke();
    }

    @Test
    public void positiveIncludePageRelative2Test() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveIncludePageRelative2.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveIncludePageRelative2");
        this.invoke();
    }

    @Test
    public void positiveIncludeForwardTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveIncludeForward.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveIncludeForward");
        this.invoke();
    }

    @Test
    public void includeMappedServletTest() throws Exception {
        String testName = "includeMappedServletTest";
        TEST_PROPS.setProperty("request", "GET /jsp_coresyntx_act_include_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "shoule not be served");
        this.invoke();
    }

    @Test
    public void staticStaticTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_coresyntx_act_include_web/staticStatic_A.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "In /include/C.jsp");
        this.invoke();
    }

    @Test
    public void dynamicDynamicTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_coresyntx_act_include_web/dynamicDynamic_A.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "In /include/C.jsp");
        this.invoke();
    }

    @Test
    public void dynamicStaticTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_coresyntx_act_include_web/dynamicStatic_A.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "In /include/C.jsp");
        this.invoke();
    }

    @Test
    public void staticDynamicTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_coresyntx_act_include_web/staticDynamic_A.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "In /C.jsp");
        this.invoke();
    }
}

