/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.core_syntax.scripting.expressions;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public static String packagePath = URLClientIT.class.getPackageName().replace(".", "/");

    public URLClientIT() throws Exception {
        this.setGeneralURI("/jsp/spec/core_syntax/scripting/expressions");
        this.setContextRoot("/jsp_coresyntx_script_expressions_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_coresyntx_script_expressions_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_coresyntx_script_expressions_web.xml"));
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveExprWhiteSpace.jsp")), "positiveExprWhiteSpace.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveExprComment.jsp")), "positiveExprComment.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/positiveExpr.jsp")), "positiveExpr.jsp");
        return archive;
    }

    @Test
    public void positiveExprTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveExpr.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveExpr");
        this.invoke();
    }

    @Test
    public void positiveExprCommentTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveExprComment.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveExprComment");
        this.invoke();
    }

    @Test
    public void positiveExprWhiteSpaceTest() throws Exception {
        InputStream gfStream = URLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveExprWhiteSpace.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveExprWhiteSpace");
        this.invoke();
    }
}

