/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.basic;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.basic.A;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.junit.jupiter.api.AfterEach;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestData() {
        try {
            this.getEntityTransaction().begin();
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("9", null, 9, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    protected void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM A_BASIC").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

