/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.collectiontable;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.collectiontable.A;
import ee.jakarta.tck.persistence.core.annotations.collectiontable.Address;
import java.util.HashSet;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "Address"};
        return this.createDeploymentJar("jpa_core_annotations_collectiontable.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void collectionTable1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin collectionTable1");
        boolean pass = false;
        A aRef = null;
        Object bCol = null;
        Object newCol = null;
        try {
            logger.log(System.Logger.Level.TRACE, "New instances");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA", "01801");
            Address addr2 = new Address("Some Address", "Boston", "MA", "01803");
            HashSet<Address> s1 = new HashSet<Address>();
            s1.add(addr1);
            s1.add(addr2);
            aRef = new A("1", "bean1", 1);
            aRef.setAddress(s1);
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)aRef);
            this.getEntityTransaction().commit();
            this.getEntityTransaction().begin();
            A newA = this.findA("1");
            Set<Address> newAddressSet = newA.getAddress();
            this.dumpAddresses(newAddressSet);
            boolean pass1 = false;
            boolean pass2 = false;
            for (Address addr : newAddressSet) {
                if (addr.getStreet().equals("1 Network Drive") && addr.getCity().equals("Burlington") && addr.getState().equals("MA") && addr.getZip().equals("01801")) {
                    pass1 = true;
                    logger.log(System.Logger.Level.TRACE, "pass1 = " + pass1);
                }
                if (!addr.getStreet().equals("Some Address") || !addr.getCity().equals("Boston") || !addr.getState().equals("MA") || !addr.getZip().equals("01803")) continue;
                pass2 = true;
                logger.log(System.Logger.Level.TRACE, "pass2 = " + pass2);
            }
            if (pass1 && pass2) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("collectionTable1 failed");
        }
    }

    private A findA(String id) {
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private void dumpAddresses(Set<Address> addr) {
        logger.log(System.Logger.Level.TRACE, "address Data");
        logger.log(System.Logger.Level.TRACE, "---------------");
        logger.log(System.Logger.Level.TRACE, "size=" + addr.size());
        int elem = 1;
        for (Address v : addr) {
            logger.log(System.Logger.Level.TRACE, "- Element #" + elem++);
            if (v != null) {
                logger.log(System.Logger.Level.TRACE, "  street=" + v.getStreet() + ", city=" + v.getCity() + ", state=" + v.getState() + ", zip=" + v.getZip());
                continue;
            }
            logger.log(System.Logger.Level.TRACE, "  address=numm");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from COLTAB_ADDRESS").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from COLTAB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

