/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.convert;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.convert.Address;
import ee.jakarta.tck.persistence.core.annotations.convert.B;
import ee.jakarta.tck.persistence.core.annotations.convert.Country;
import ee.jakarta.tck.persistence.core.annotations.convert.Customer;
import ee.jakarta.tck.persistence.core.annotations.convert.Employee;
import ee.jakarta.tck.persistence.core.annotations.convert.FullTimeEmployee;
import ee.jakarta.tck.persistence.core.annotations.convert.FullTimeEmployee2;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Address", pkgName + "B", pkgName + "CharConverter", pkgName + "CommaConverter", pkgName + "Country", pkgName + "Customer", pkgName + "Department", pkgName + "DisableAutoApplyConverter", pkgName + "DotConverter", pkgName + "DotConverter2", pkgName + "Employee", pkgName + "Employee2", pkgName + "Employee3", pkgName + "FullTimeEmployee", pkgName + "FullTimeEmployee2", pkgName + "IntegerConverter", pkgName + "NumberToStateConverter", pkgName + "SalaryConverter", pkgName + "SpaceConverter"};
        return this.createDeploymentJar("jpa_core_annotations_convert.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void convertTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Employee expected = new Employee(1, "Alan", "Smith", "3#5#0#0#0.0");
            logger.log(System.Logger.Level.TRACE, "Persisting Employee");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find the previously persisted Employees and verify them and their departments");
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)expected.getId());
            if (emp != null) {
                logger.log(System.Logger.Level.TRACE, "Found employee: " + emp.getId());
                expected.setSalary(expected.getSalary().replace("#", ""));
                if (emp.equals(expected)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected employee:" + emp.toString());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected:" + expected.toString() + ", actual:" + emp.toString());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null Employee instead of:" + expected);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("convertTest failed");
        }
    }

    @Test
    public void convertExceptionDuringPersistTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "isActive():" + this.getEntityTransaction().isActive());
            B b = new B("1", "name1", 1, new Address("500 Oracle Parkway", "Redwood Shores", -1));
            this.getEntityManager().persist((Object)b);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.ERROR, "Did not received expected PersistenceException");
        }
        catch (PersistenceException pe) {
            logger.log(System.Logger.Level.TRACE, "Received expected PersistenceException");
            if (this.getEntityTransaction().getRollbackOnly()) {
                logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("convertExceptionDuringPersistTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void convertExceptionDuringLoadTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "isActive():" + this.getEntityTransaction().isActive());
            B b = new B("1", "name1", 1, new Address("500 Oracle Parkway", "Redwood Shores", -2));
            logger.log(System.Logger.Level.TRACE, "Persisting B");
            this.getEntityManager().persist((Object)b);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            try {
                logger.log(System.Logger.Level.TRACE, "Finding B");
                B b1 = (B)this.getEntityManager().find(B.class, (Object)"1");
                logger.log(System.Logger.Level.ERROR, "Did not received expected PersistenceException");
            }
            catch (PersistenceException pe) {
                logger.log(System.Logger.Level.TRACE, "Received expected PersistenceException");
                if (this.getEntityTransaction().getRollbackOnly()) {
                    logger.log(System.Logger.Level.TRACE, "Transaction was marked for rollback");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Transaction was not marked for rollback");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.log(System.Logger.Level.ERROR, "Unexpected exception received:", (Throwable)ex);
            }
            finally {
                try {
                    if (this.getEntityTransaction().isActive()) {
                        this.getEntityTransaction().rollback();
                    }
                }
                catch (Exception re) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected Exception while rolling back TX:", (Throwable)re);
                }
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("convertExceptionDuringLoadTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void convertsTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            String street = "500.Oracle.Parkway";
            String city = "Redwood Shores";
            B b = new B("1", "name1", 1000, new Address(street, city, 1));
            this.getEntityManager().persist((Object)b);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            B b1 = (B)this.getEntityManager().find(B.class, (Object)"1");
            logger.log(System.Logger.Level.TRACE, "B:" + b1.toString());
            if (b1.getBValue().equals(1110)) {
                logger.log(System.Logger.Level.TRACE, "Received expected value:" + b1.getBValue());
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Converter was not properly applied, expected value:1002, actual" + b1.getBValue());
            }
            Address a = b1.getAddress();
            if (a.getStreet().equals(street.replace(".", "_"))) {
                logger.log(System.Logger.Level.TRACE, "Received expected street:" + a.getStreet());
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Converter was not properly applied, expected street:" + street + ", actual:" + a.getStreet());
            }
            if (a.getState() == 1) {
                logger.log(System.Logger.Level.TRACE, "Received expected state:" + a.getState());
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Converter was not properly applied, expected state: 1, actual: " + a.getState());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("convertsTest failed");
        }
    }

    @Test
    public void mappedSuperClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            char[] c = new char[]{'D', 'o', 'e'};
            FullTimeEmployee expected = new FullTimeEmployee(1, "John", c, "3#5#0#0#0.0");
            logger.log(System.Logger.Level.TRACE, "Persisting FullTimeEmployee:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find the previously persisted Employees and verify them and their departments");
            FullTimeEmployee emp = (FullTimeEmployee)this.getEntityManager().find(FullTimeEmployee.class, (Object)expected.getId());
            if (emp != null) {
                logger.log(System.Logger.Level.TRACE, "Found FullTimeEmployee: " + emp.getId());
                expected.setSalary(expected.getSalary().replace("#", ""));
                c = new char[]{'J', 'a', 'm', 'e', 's'};
                expected.setLastName(c);
                if (emp.equals(expected)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected FullTimeEmployee:" + emp.toString());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected:" + expected.toString() + ", actual:" + emp.toString());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null FullTimeEmployee instead of:" + expected);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("mappedSuperClassTest failed");
        }
    }

    @Test
    public void mappedSuperClass2Test() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            FullTimeEmployee2 expected = new FullTimeEmployee2(1, "J.o.h.n", "Hill", "3500.0");
            logger.log(System.Logger.Level.TRACE, "Persisting FullTimeEmployee2:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find the previously persisted Employees and verify them and their departments");
            FullTimeEmployee2 emp = (FullTimeEmployee2)this.getEntityManager().find(FullTimeEmployee2.class, (Object)expected.getId());
            if (emp != null) {
                logger.log(System.Logger.Level.TRACE, "Found FullTimeEmployee2: " + emp.getId());
                expected.setFirstName(expected.getFirstName().replace(".", "#"));
                if (emp.equals(expected)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected FullTimeEmployee:" + emp.toString());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected:" + expected.toString() + ", actual:" + emp.toString());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null FullTimeEmployee instead of:" + expected);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("mappedSuperClass2Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void convert2Test() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            Employee expected = new Employee(1, "Alan", "Smith", "3#5#0#0#0.0");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            pass1 = true;
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        this.clearCache();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Testing JPQL");
            List o = this.getEntityManager().createQuery("Select e from Employee e WHERE e.id = 1", Employee.class).getResultList();
            if (o.size() == 1) {
                Employee emp = (Employee)o.get(0);
                logger.log(System.Logger.Level.TRACE, "Employee:" + emp.toString());
                if (emp.getSalary().equals("35000.0")) {
                    logger.log(System.Logger.Level.TRACE, "Received expected value:" + emp.getSalary());
                    pass2 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Converter was not properly applied, expected value:35000.0, actual" + emp.getSalary());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected 1 entity to be returned, actual:" + o.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        this.clearCache();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Testing Criteria");
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            CriteriaQuery cquery = cbuilder.createQuery(Employee.class);
            if (cquery != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
                Root employee = cquery.from(Employee.class);
                cquery.select((Selection)employee).where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)1));
                Employee emp = (Employee)this.getEntityManager().createQuery(cquery).getSingleResult();
                if (emp != null) {
                    logger.log(System.Logger.Level.TRACE, "Employee:" + emp.toString());
                    if (emp.getSalary().equals("35000.0")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected value:" + emp.getSalary());
                        pass3 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Converter was not properly applied, expected value:35000.0, actual" + emp.getSalary());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Null Employee result was returned");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "createQuery returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("converts2Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void convert3Test() throws Exception {
        Object expected;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            expected = new Employee(1, "Alan", "Smith", "0");
            this.getEntityManager().persist(expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            pass1 = true;
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        this.clearCache();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Testing JPQL");
            expected = "54321.0";
            this.getEntityManager().createQuery("Update Employee e set e.salary='5#4#3#2#1.0'  WHERE e.id = 1").executeUpdate();
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            if (emp != null) {
                logger.log(System.Logger.Level.TRACE, "Found employee: " + emp.getId());
                if (emp.getSalary().equals(expected)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected value:" + emp.getSalary());
                    pass2 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Converter was not properly applied, expected value:" + (String)expected + ", actual" + emp.getSalary());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null Employee");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        this.clearCache();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Testing Criteria");
            expected = "3500.0";
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            CriteriaUpdate cd = cbuilder.createCriteriaUpdate(Employee.class);
            Root employee = cd.from(Employee.class);
            logger.log(System.Logger.Level.TRACE, "Obtained expected root");
            cd.set("salary", (Object)"3#5#0#0.0");
            cd.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)1));
            int actual = this.getEntityManager().createQuery(cd).executeUpdate();
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            if (actual == 1) {
                this.clearCache();
                this.getEntityTransaction().begin();
                Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
                if (emp != null) {
                    logger.log(System.Logger.Level.TRACE, "Found employee: " + emp.getId());
                    if (emp.getSalary().equals("3500.0")) {
                        logger.log(System.Logger.Level.TRACE, "Received expected value:" + emp.getSalary());
                        pass3 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Converter was not properly applied, expected value:" + (String)expected + ", actual" + emp.getSalary());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Find returned null Employee instead of:" + (String)expected);
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected 1 update, actual:" + actual);
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception received:", (Throwable)ex);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception while rolling back TX:", (Throwable)re);
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("converts3Test failed");
        }
    }

    @Test
    public void embeddedTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            String name = "john smith";
            String country = "United States";
            Customer expected = new Customer("1", name, new Country(country, "USA"));
            logger.log(System.Logger.Level.TRACE, "Persisting Customer:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find the previously persisted Customer and Country and verify them");
            Customer cust = (Customer)this.getEntityManager().find(Customer.class, (Object)expected.getId());
            if (cust != null) {
                logger.log(System.Logger.Level.TRACE, "Found Customer: " + cust.toString());
                String tmp = country.replace(" ", "_");
                if (cust.getCountry().getCountry().equals(tmp)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected Country:" + cust.getCountry().getCountry());
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected:" + tmp + ", actual:" + cust.getCountry().getCountry());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("embeddedTest failed");
        }
    }

    @Test
    public void elementCollectionBasicType() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer expected = new Customer("1");
            ArrayList<String> phones = new ArrayList<String>();
            phones.add("781,442,2010");
            phones.add("781,442,2011");
            phones.add("781,442,2012");
            ArrayList<String> expectedphones = new ArrayList<String>();
            for (String p : phones) {
                expectedphones.add(p.replace(",", "-"));
            }
            expected.setPhones(phones);
            logger.log(System.Logger.Level.TRACE, "Persisting Customer:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find the previously persisted Customer and Country and verify them");
            Customer cust = (Customer)this.getEntityManager().find(Customer.class, (Object)expected.getId());
            if (cust != null) {
                logger.log(System.Logger.Level.TRACE, "Found Customer: " + cust.toString());
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    logger.log(System.Logger.Level.TRACE, "Received expected Phones:");
                    for (String s : cust.getPhones()) {
                        logger.log(System.Logger.Level.TRACE, "phone:" + s);
                    }
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results.");
                    for (String s : expectedphones) {
                        logger.log(System.Logger.Level.TRACE, "expected:" + s);
                    }
                    logger.log(System.Logger.Level.ERROR, "actual:");
                    for (String s : cust.getPhones()) {
                        logger.log(System.Logger.Level.TRACE, "actual:" + s);
                    }
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("elementCollectionBasicType failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM B_EMBEDDABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PHONES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

