/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.embeddableMapValue;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.embeddableMapValue.Address;
import ee.jakarta.tck.persistence.core.annotations.embeddableMapValue.Employee;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import java.util.HashMap;
import java.util.Map;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Address", pkgName + "Employee"};
        return this.createDeploymentJar("jpa_core_annotations_embeddableMapValue.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void embeddableMapValue() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin embeddableMapValue");
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        EntityManager em = this.getEntityManager();
        EntityTransaction et = this.getEntityTransaction();
        try {
            logger.log(System.Logger.Level.TRACE, "New instances");
            Address addr1 = new Address("1", "1 Network Drive", "Burlington", "MA", "01801");
            Address addr2 = new Address("2", "Some Address", "Boston", "MA", "01803");
            Employee emp1 = new Employee(1, "Barack", "Obama");
            HashMap<String, Address> locationAddressMap = new HashMap<String, Address>();
            locationAddressMap.put("home", addr2);
            locationAddressMap.put("office", addr1);
            emp1.setLocationAddress(locationAddressMap);
            logger.log(System.Logger.Level.TRACE, "Created new Employee");
            et.begin();
            em.persist((Object)emp1);
            logger.log(System.Logger.Level.TRACE, "persisted new Employee");
            em.flush();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "query for Employee");
            Employee newEmployee = (Employee)em.find(Employee.class, (Object)1);
            int newEmployeeId = newEmployee.getId();
            String newEmployeeFirstName = newEmployee.getFirstName();
            String newEmployeeLastName = newEmployee.getLastName();
            logger.log(System.Logger.Level.TRACE, "Employee Id = " + newEmployeeId);
            logger.log(System.Logger.Level.TRACE, "Employee First Name = " + newEmployeeFirstName);
            logger.log(System.Logger.Level.TRACE, "Employee Last Name = " + newEmployeeLastName);
            if (newEmployeeId == 1) {
                pass1 = true;
                logger.log(System.Logger.Level.TRACE, "Employee Id match");
            }
            if (newEmployeeFirstName.equals("Barack")) {
                logger.log(System.Logger.Level.TRACE, "Employee First Name match");
                pass2 = true;
            }
            if (newEmployeeLastName.equals("Obama")) {
                logger.log(System.Logger.Level.TRACE, "Employee Last Name match");
                pass3 = true;
            }
            Map<String, Address> newLocationAddressMap = newEmployee.getLocationAddress();
            Address homeAddress = newLocationAddressMap.get("home");
            Address officeAddress = newLocationAddressMap.get("office");
            if (officeAddress.getStreet().equals("1 Network Drive") && officeAddress.getCity().equals("Burlington") && officeAddress.getState().equals("MA") && officeAddress.getZip().equals("01801")) {
                pass4 = true;
                logger.log(System.Logger.Level.TRACE, "Employee officeAddress match");
            }
            if (homeAddress.getStreet().equals("Some Address") && homeAddress.getCity().equals("Boston") && homeAddress.getState().equals("MA") && homeAddress.getZip().equals("01803")) {
                pass5 = true;
                logger.log(System.Logger.Level.TRACE, "Employee HomeAddress match");
            }
            et.commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception :", (Throwable)e);
        }
        finally {
            try {
                if (et.isActive()) {
                    et.rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            logger.log(System.Logger.Level.ERROR, "embeddableMapValue failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from COLTAB_EMP_EMBEDED_ADDRESS").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from EMPLOYEE_EMBEDED_ADDRESS").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

