/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.lob;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.lob.DataTypes;
import java.util.Arrays;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private DataTypes dataTypes;
    private Byte[] smallByteArray = null;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DataTypes"};
        return this.createDeploymentJar("jpa_core_annotations_lob.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData();
            logger.log(System.Logger.Level.TRACE, "Done creating test data");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lobTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        Object[] largeByteArray = null;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "FIND DataTypes and verify initial value");
            this.dataTypes = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.dataTypes && Arrays.equals((Object[])this.smallByteArray, (Object[])this.dataTypes.getByteArrayData())) {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass1 = true;
                logger.log(System.Logger.Level.TRACE, "DataType Entity is not null, setting byteData ");
                largeByteArray = this.createLargeByteArray();
                this.dataTypes.setByteArrayData((Byte[])largeByteArray);
                this.getEntityManager().merge((Object)this.dataTypes);
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.INFO, "FIND DataTypes again and verify updated value");
                this.dataTypes = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
                logger.log(System.Logger.Level.TRACE, "Check results");
                if (null != this.dataTypes && Arrays.equals(largeByteArray, (Object[])this.dataTypes.getByteArrayData())) {
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                    pass2 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Unexpected result in array comparison.");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Unexpected result in array comparison.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("lobTest failed");
        }
    }

    public void createTestData() {
        logger.log(System.Logger.Level.TRACE, "createTestData");
        try {
            this.getEntityTransaction().begin();
            this.smallByteArray = this.createSmallByteArray();
            this.dataTypes = new DataTypes(1, this.smallByteArray);
            this.getEntityManager().persist((Object)this.dataTypes);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    private Byte[] createSmallByteArray() {
        StringBuffer strbuf = new StringBuffer();
        for (int i = 0; i < 1024; ++i) {
            strbuf.append(i);
        }
        String value = strbuf.toString();
        System.out.println("String Buffer :" + value);
        byte[] myByte = value.getBytes();
        Byte[] convertedByte = new Byte[myByte.length];
        for (int i = 0; i < myByte.length; ++i) {
            convertedByte[i] = myByte[i];
        }
        return convertedByte;
    }

    private Byte[] createLargeByteArray() {
        StringBuffer strbuf = new StringBuffer();
        for (int i = 0; i < 4096; ++i) {
            strbuf.append(i);
        }
        String value = strbuf.toString();
        System.out.println("String Buffer :" + value);
        byte[] myByte = value.getBytes();
        Byte[] convertedByte = new Byte[myByte.length];
        for (int i = 0; i < myByte.length; ++i) {
            convertedByte[i] = myByte[i];
        }
        return convertedByte;
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

