/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.basic;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.basic.Order;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Order"};
        return this.createDeploymentJar("jpa_core_basic.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void updateOrderTest() throws Exception {
        int i;
        boolean pass = true;
        int count = 6;
        Order order = null;
        this.getEntityTransaction().begin();
        for (i = 1; i < 6; ++i) {
            order = new Order(i, 100 * i);
            this.getEntityManager().persist((Object)order);
            logger.log(System.Logger.Level.TRACE, "persisted order " + order);
        }
        this.getEntityTransaction().commit();
        logger.log(System.Logger.Level.TRACE, "find and removing the previously persisted orders");
        this.getEntityTransaction().begin();
        for (i = 1; i < 6; ++i) {
            order = (Order)this.getEntityManager().find(Order.class, (Object)i);
            if (order != null) {
                this.getEntityManager().remove((Object)order);
                logger.log(System.Logger.Level.TRACE, "Found and removed order " + order);
                continue;
            }
            logger.log(System.Logger.Level.ERROR, "persisted order[" + i + "] DOES NOT EXIST");
            pass = false;
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            logger.log(System.Logger.Level.TRACE, "clearing the persistence context");
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "verify the previously removed orders were removed");
            for (i = 1; i < 6; ++i) {
                order = (Order)this.getEntityManager().find(Order.class, (Object)i);
                if (order == null) {
                    logger.log(System.Logger.Level.TRACE, "persisted order[" + i + "] was removed successfully");
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "order[" + i + "] was NOT removed");
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("updateOrderTest failed");
        }
    }

    @Test
    public void newEntityTest() throws Exception {
        boolean pass = false;
        logger.log(System.Logger.Level.TRACE, "Instantiate an order ");
        Order order = new Order(1, 101);
        logger.log(System.Logger.Level.TRACE, "Try to find it");
        Order order2 = (Order)this.getEntityManager().find(Order.class, (Object)1);
        if (order2 == null) {
            logger.log(System.Logger.Level.TRACE, "Did not find order as expected");
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Found order when it should not exist" + order2.toString());
        }
        if (!pass) {
            throw new Exception("newEntityTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

