/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaQuery;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.Address_;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.Order_;
import ee.jakarta.tck.persistence.common.schema30.UtilOrderData;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client1
extends UtilOrderData {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A"};
        classes = Client1.concat((String[])this.getSchema30classes(), (String[])classes);
        return this.createDeploymentJar("jpa_core_criteriaapi_CriteriaQuery1.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void fromClass() throws Exception {
        boolean pass = false;
        Double expectedTotalPrice = 4500.0;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            Root order = cquery.from(this.getEntityManager().getMetamodel().entity(Order.class));
            EntityType Order_2 = order.getModel();
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.lt((Expression)order.get(Order_2.getSingularAttribute("totalPrice", Double.class)), (Number)expectedTotalPrice)));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            int expectedResultSize = 3;
            if (result != null) {
                if (result.size() == expectedResultSize) {
                    logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected = " + expectedResultSize + " received = " + result.size());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Missing expected result");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("fromClass failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void fromEntityType() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        Double expectedTotalPrice = 4500.0;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            Root p;
            Root order = cquery.from(this.getEntityManager().getMetamodel().entity(Order.class));
            EntityType Order_2 = order.getModel();
            Root exp = p = order;
            Expression type = p.type();
            if (type != null) {
                logger.log(System.Logger.Level.TRACE, "Path.type() returned non-null result");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected non-null Path.type()");
            }
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.lt((Expression)p.get(Order_2.getSingularAttribute("totalPrice", Double.class)), (Number)expectedTotalPrice)));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            int expectedResultSize = 3;
            if (result != null) {
                if (result.size() == expectedResultSize) {
                    logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                    pass2 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected = " + expectedResultSize + " received = " + result.size());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Missing expected result");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("fromEntityType failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void select() throws Exception {
        boolean pass = false;
        Double expectedTotalPrice = 4500.0;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.lt((Expression)order.get(Order_2.getSingularAttribute("totalPrice", Double.class)), (Number)expectedTotalPrice)));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            int expectedResultSize = 3;
            if (result != null) {
                if (result.size() == expectedResultSize) {
                    logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected = " + expectedResultSize + " received = " + result.size());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Missing expected result");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("select test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void wherePredicateArrayTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(Integer.valueOf(this.customerRef[3].getId()));
        Collections.sort(expected);
        ArrayList<Integer> actual = new ArrayList<Integer>();
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Testing initial query");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get("name"), (Object)"Robert E. Bissett"));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            logger.log(System.Logger.Level.INFO, "Modify query but this change should not yet take effect");
            cquery.where((Expression)cbuilder.like((Expression)customer.get(Customer_.home).get(Address_.zip), "%77"));
            Predicate[] predArray = new Predicate[]{cbuilder.like((Expression)customer.get(Customer_.name), "Karen%"), cbuilder.like((Expression)customer.get(Customer_.name), "%Tegan")};
            cquery.where(predArray);
            List result = tquery.getResultList();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass1 = true;
            }
            logger.log(System.Logger.Level.INFO, "Now verify query change does take effect");
            actual.clear();
            expected.clear();
            result.clear();
            expected.add(Integer.valueOf(this.customerRef[5].getId()));
            tquery = this.getEntityManager().createQuery(cquery);
            result = tquery.getResultList();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
                logger.log(System.Logger.Level.TRACE, "Found id:" + c.getId());
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("wherePredicateArrayTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void fromGetParentPathTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        String expected = "ee.jakarta.tck.persistence.common.schema30.Order";
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            Root order;
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Order.class);
            Root from = order = cquery.from(Order.class);
            Path path = from.getParentPath();
            if (path == null) {
                logger.log(System.Logger.Level.TRACE, "Received expected null");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected:null, actual:" + path);
            }
            Path p = from.join(Order_.creditCard).getParentPath();
            if (p != null) {
                String name = p.getModel().getBindableJavaType().getName();
                if (name != null) {
                    if (name.equals(expected)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected name:" + name);
                        pass2 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected:" + expected + ", actual:" + name);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Null was returned for p.getModel().getBindableJavaType().getName()");
                    logger.log(System.Logger.Level.ERROR, "p.getModel:" + p.getModel());
                    logger.log(System.Logger.Level.ERROR, "p.getModel().getBindableJavaType():" + p.getModel().getBindableJavaType());
                    logger.log(System.Logger.Level.ERROR, "p.getModel().getBindableJavaType().getName():" + p.getModel().getBindableJavaType().getName());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getParentPath() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("fromGetParentPathTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void getParameters() throws Exception {
        boolean pass = false;
        Double expectedTotalPrice = 4500.0;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.lt((Expression)order.get(Order_2.getSingularAttribute("totalPrice", Double.class)), (Number)expectedTotalPrice)));
            Set paramSet = cquery.getParameters();
            if (paramSet != null) {
                if (paramSet.isEmpty()) {
                    pass = true;
                    logger.log(System.Logger.Level.TRACE, "Received expected results");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received Incorrect results");
                }
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getParameters test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void distinctNotSpecifiedTest() throws Exception {
        boolean pass = false;
        try {
            logger.log(System.Logger.Level.TRACE, "find All customer ids from Orders");
            CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery();
            if (cquery != null) {
                Root order = cquery.from(Order.class);
                EntityType Order_2 = order.getModel();
                Metamodel mm = this.getEntityManager().getMetamodel();
                EntityType Customer_2 = mm.entity(Customer.class);
                cquery.select((Selection)order.get(Order_2.getSingularAttribute("customer", Customer.class)).get(Customer_2.getSingularAttribute("id", String.class)));
                TypedQuery tq = this.getEntityManager().createQuery(cquery);
                List o = tq.getResultList();
                Integer[] expectedPKs = new Integer[]{Integer.parseInt("1"), Integer.parseInt("2"), Integer.parseInt("3"), Integer.parseInt("4"), Integer.parseInt("4"), Integer.parseInt("5"), Integer.parseInt("6"), Integer.parseInt("7"), Integer.parseInt("8"), Integer.parseInt("9"), Integer.parseInt("10"), Integer.parseInt("11"), Integer.parseInt("12"), Integer.parseInt("13"), Integer.parseInt("14"), Integer.parseInt("14"), Integer.parseInt("15"), Integer.parseInt("16"), Integer.parseInt("17"), Integer.parseInt("18")};
                if (!this.checkEntityPK(o, expectedPKs, true, true)) {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + o.size());
                } else {
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("distinctNotSpecifiedTest failed");
        }
    }
}

