/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.From;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.UtilCustomerData;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client2
extends UtilCustomerData {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_from2.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void joinStringTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join address = customer.join("work");
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)address.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinStringTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void joinStringJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join address = customer.join("work", JoinType.INNER);
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)address.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinStringJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void joinSingularAttributeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join address = customer.join(Customer_.work);
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)address.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinSingularAttributeTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void joinSingularAttributeJoinTypeTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join address = customer.join(Customer_.work, JoinType.INNER);
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)address.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinSingularAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void fromGetCorrelationParentTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.correlate(customer);
            boolean isCorr = sqc.isCorrelated();
            if (isCorr) {
                logger.log(System.Logger.Level.TRACE, "From.isCorrelated() return true");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected From.isCorrelated() to return true, actual:" + isCorr);
            }
            From f = sqc.getCorrelationParent();
            String name = f.getJavaType().getSimpleName();
            if (name.equals("Customer")) {
                logger.log(System.Logger.Level.TRACE, "Received expected parent:" + name);
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected getCorrelationParent() to return Customer, actual:" + name);
            }
            Join w = sqc.join("work");
            sq.select((Expression)w.get("state"));
            sq.where((Expression)cbuilder.equal((Expression)w.get("state"), (Expression)cbuilder.parameter(String.class, "state")));
            cquery.where((Expression)customer.get("home").get("state").in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("state", (Object)"MA");
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "7", "8", "9", "11", "13", "15", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "test_subquery_in:  Did not get expected results.  Expected 11 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass3 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("fromGetCorrelationParentTest failed");
        }
    }
}

