/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManagerFactory;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entityManagerFactory.Member;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client4
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client4.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client4.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Member_", pkgName + "Member", pkgName + "Order_", pkgName + "Order"};
        return this.createDeploymentJar("jpa_core_entityManagerFactory4.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupMember() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanupNoData() throws Exception {
        try {
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    @Test
    public void callInTransactionTest() throws Exception {
        int MEMBER_ID = 10;
        boolean pass = false;
        try {
            Member member = (Member)this.getEntityManager().getEntityManagerFactory().callInTransaction(em -> {
                Member newMember = new Member(10, String.valueOf(10));
                em.persist((Object)newMember);
                return newMember;
            });
            Member foundMember = (Member)this.getEntityManager().find(Member.class, (Object)10);
            if (member.equals(foundMember)) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Stored entity data are not same as found");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("callInTransactionTest failed");
        }
    }

    @Test
    public void runInTransactionTest() throws Exception {
        int MEMBER_ID = 11;
        boolean pass = false;
        try {
            this.getEntityManager().getEntityManagerFactory().runInTransaction(em -> {
                Member newMember = new Member(11, String.valueOf(11));
                em.persist((Object)newMember);
            });
            Member foundMember = (Member)this.getEntityManager().find(Member.class, (Object)11);
            if (foundMember != null) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Stored entity data was not found");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("runInTransactionTest failed");
        }
    }

    @Test
    public void getNameTest() throws Exception {
        boolean pass = false;
        try {
            String puName = this.getEntityManager().getEntityManagerFactory().getName();
            if (this.getPersistenceUnitName().equals(puName)) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Persistence unit name |" + puName + "| doesn't match with expected |" + this.getPersistenceUnitName() + "|");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getNameTest failed");
        }
    }
}

