/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.detach.basic;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.detach.basic.A;
import jakarta.persistence.PersistenceException;
import jakarta.transaction.TransactionRolledbackException;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A"};
        return this.createDeploymentJar("jpa_core_entitytest_detach_basic.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void detachBasicTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin detachBasicTest1");
        boolean pass = false;
        A aRef = new A("1", "a1", 1);
        try {
            logger.log(System.Logger.Level.TRACE, "Persist Instance");
            this.createA(aRef);
            this.clearCache();
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "tx started, see if entity is detached");
            if (this.getEntityManager().contains((Object)aRef)) {
                logger.log(System.Logger.Level.ERROR, "contains method returned true; expected false (detached), test fails.");
                pass = false;
            } else {
                try {
                    logger.log(System.Logger.Level.TRACE, "try remove");
                    this.getEntityManager().remove((Object)aRef);
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "IllegalArgumentException caught as expected", (Throwable)iae);
                    pass = true;
                }
            }
            logger.log(System.Logger.Level.TRACE, "tx commit");
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "or, Transaction commit will fail.  Test the commit failed by testing the transaction is marked for rollback");
            if (!pass) {
                if (e instanceof TransactionRolledbackException || e instanceof PersistenceException) {
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Not TransactionRolledbackException nor PersistenceException, totally unexpected:", (Throwable)e);
                }
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("detachBasicTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void detachBasicTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin detachBasicTest2");
        boolean pass = false;
        A expected = new A("1", "a1", 1);
        try {
            logger.log(System.Logger.Level.TRACE, "Persist Instance");
            this.createA(new A("1", "a1", 1));
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Executing find");
            A newA = (A)this.getEntityManager().find(A.class, (Object)"1");
            logger.log(System.Logger.Level.TRACE, "newA:" + newA.toString());
            logger.log(System.Logger.Level.TRACE, "changing name");
            newA.setAName("foobar");
            logger.log(System.Logger.Level.TRACE, "newA:" + newA.toString());
            logger.log(System.Logger.Level.TRACE, "executing detach");
            this.getEntityManager().detach((Object)newA);
            logger.log(System.Logger.Level.TRACE, "newA:" + newA.toString());
            logger.log(System.Logger.Level.TRACE, "tx commit");
            this.getEntityTransaction().commit();
            A newAA = (A)this.getEntityManager().find(A.class, (Object)"1");
            logger.log(System.Logger.Level.TRACE, "newAA:" + newAA.toString());
            if (expected.equals(newAA)) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Changes made to entity were persisted even though it was detached without a flush");
                logger.log(System.Logger.Level.ERROR, "expected A:" + expected.toString() + ", actual A:" + newAA.toString());
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("detachBasicTest2 failed");
        }
    }

    private void createA(A a) {
        logger.log(System.Logger.Level.TRACE, "Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

