/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.detach.oneXone;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.detach.oneXone.A;
import ee.jakarta.tck.persistence.core.entitytest.detach.oneXone.B;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.PersistenceException;
import jakarta.transaction.TransactionRolledbackException;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "B"};
        return this.createDeploymentJar("jpa_core_entitytest_detach_oneXone.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Entering Setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void detach1X1Test1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin detach1X1Test1");
        boolean pass = false;
        A aRef = new A("1", "a1", 1);
        try {
            logger.log(System.Logger.Level.TRACE, "Persist Instance");
            this.createA(aRef);
            this.clearCache();
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Call contains to determine if the instance is detached");
            if (this.getEntityManager().contains((Object)aRef)) {
                logger.log(System.Logger.Level.TRACE, "entity is not detached, cannot proceed with test.");
                pass = false;
            } else {
                try {
                    logger.log(System.Logger.Level.TRACE, "Status is false as expected, try perist()");
                    this.getEntityManager().persist((Object)aRef);
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "IllegalArgumentException thrown trying to persist a detached entity", (Throwable)iae);
                    pass = true;
                }
                catch (EntityExistsException eee) {
                    logger.log(System.Logger.Level.TRACE, "entityExistsException thrown trying to persist an existing entity", (Throwable)eee);
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "or, Transaction commit will fail. Test the commit failed by testing the transaction is marked for rollback");
            if (!pass && (e instanceof TransactionRolledbackException || e instanceof PersistenceException)) {
                pass = true;
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("detach1X1Test1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void detach1X1Test2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin detach1X1Test2");
        boolean pass = false;
        A a1 = new A("2", "a2", 2);
        B bRef = new B("2", "a2", 2, a1);
        try {
            logger.log(System.Logger.Level.TRACE, "Persist B");
            this.createB(bRef);
            this.clearCache();
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "get Instance Status ");
            if (this.getEntityManager().contains((Object)bRef)) {
                logger.log(System.Logger.Level.TRACE, "contains method returned true; unexpected, test fails.");
                pass = false;
            } else {
                try {
                    logger.log(System.Logger.Level.TRACE, "Status is false as expected, try remove");
                    this.getEntityManager().remove((Object)bRef);
                }
                catch (IllegalArgumentException iae) {
                    logger.log(System.Logger.Level.TRACE, "IllegalArgumentException caught as expected  trying to remove a detached entity", (Throwable)iae);
                    pass = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "or, Transaction commit will fail.   Test the commit failed by testing the transaction is marked for rollback");
            if (!pass && (e instanceof TransactionRolledbackException || e instanceof PersistenceException)) {
                pass = true;
            }
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("detach1X1Test2 failed");
        }
    }

    private void createA(A a) {
        logger.log(System.Logger.Level.TRACE, "Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    private void createB(B b) {
        logger.log(System.Logger.Level.TRACE, "Entered createB method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)b);
        this.getEntityTransaction().commit();
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

