/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.remove.oneXone;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.remove.oneXone.A;
import ee.jakarta.tck.persistence.core.entitytest.remove.oneXone.B;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "B"};
        return this.createDeploymentJar("jpa_core_entitytest_remove_oneXone.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1X1Test1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin remove1X1Test1");
        boolean pass = false;
        A a1 = new A("1", "a1", 1);
        B bRef = new B("1", "b1", 1, a1);
        try {
            this.getEntityTransaction().begin();
            boolean result = this.getInstanceStatus(bRef);
            if (!result) {
                logger.log(System.Logger.Level.TRACE, "Instance state is not managed as expected. Try invoking remove on it.");
                this.getEntityManager().remove((Object)bRef);
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Instance state is managed.  Unexpected as this is NEW instance.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception during remove operation. Should have been ignored.", (Throwable)fe);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("remove1X1Test1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1X1Test2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin remove1X1Test2");
        boolean pass = true;
        A a1 = new A("2", "a2", 2);
        B bRef = new B("2", "b2", 2, a1);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().persist((Object)bRef);
            logger.log(System.Logger.Level.TRACE, "get Instance Status ");
            if (this.getInstanceStatus(bRef)) {
                logger.log(System.Logger.Level.TRACE, "Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)bRef);
                logger.log(System.Logger.Level.TRACE, "Call contains after remove()");
                pass = this.getEntityManager().contains((Object)bRef);
            } else {
                logger.log(System.Logger.Level.ERROR, "Instance is not managed, cannot proceed with test");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (pass) {
            throw new Exception("remove1X1Test2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1X1Test3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin remove1X1Test3");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("3", "a3", 3);
            this.getEntityManager().persist((Object)a1);
            B bRef = new B("3", "a3", 3, a1);
            this.getEntityManager().persist((Object)bRef);
            logger.log(System.Logger.Level.TRACE, "get Instance Status ");
            A a2 = bRef.getA1();
            status = this.getInstanceStatus(bRef);
            if (status && a2 == a1) {
                logger.log(System.Logger.Level.TRACE, "Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)bRef);
                logger.log(System.Logger.Level.TRACE, "Remove is immediately visible to the contains method");
                if (!this.getEntityManager().contains((Object)a2) && !this.getEntityManager().contains((Object)bRef)) {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "Expected Exception :", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1X1Test3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1X1Test4() throws Exception {
        boolean pass = false;
        boolean status = false;
        A a1 = new A("4", "a4", 4);
        B bRef = new B("4", "b4", 4, a1);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().persist((Object)bRef);
            logger.log(System.Logger.Level.TRACE, "get Instance Status ");
            status = this.getEntityManager().contains((Object)bRef);
            if (status) {
                logger.log(System.Logger.Level.TRACE, "entity is managed, remove");
                this.getEntityManager().remove((Object)bRef);
                this.getEntityManager().flush();
                B stillExists = this.findB("4");
                if (stillExists == null) {
                    this.getEntityManager().remove((Object)bRef);
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "entity not managed, unexpected, test fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1X1Test4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1X1Test5() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin remove1X1Test5");
        boolean pass = false;
        boolean status = false;
        A a1 = new A("5", "a5", 5);
        B bRef = new B("5", "a5", 5, a1);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().persist((Object)bRef);
            logger.log(System.Logger.Level.TRACE, "get Instance ");
            A a2 = bRef.getA1();
            logger.log(System.Logger.Level.TRACE, "get Instance Status ");
            status = this.getInstanceStatus(bRef);
            if (status && a2 == a1) {
                this.getEntityManager().remove((Object)bRef);
                this.getEntityManager().flush();
                B newB = this.findB("5");
                if (newB == null && !this.getEntityManager().contains((Object)bRef) && !this.getEntityManager().contains((Object)a1)) {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1X1Test5 failed");
        }
    }

    @Test
    public void remove1X1Test6() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin remove1X1Test6");
        boolean pass = false;
        boolean status = false;
        this.getEntityTransaction().begin();
        A a1 = new A("6", "a6", 6);
        this.getEntityManager().persist((Object)a1);
        B bRef = new B("6", "a6", 6, a1);
        this.getEntityManager().persist((Object)bRef);
        logger.log(System.Logger.Level.TRACE, "get Instance ");
        A a2 = bRef.getA1();
        logger.log(System.Logger.Level.TRACE, "get Instance Status ");
        status = this.getInstanceStatus(bRef);
        if (status && a2 == a1) {
            try {
                logger.log(System.Logger.Level.TRACE, "Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)this.findB("6"));
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.TRACE, "A removed entity is removed from the database as a result of the flush operation");
                B newB = this.findB("6");
                if (newB == null && !this.getEntityManager().contains((Object)bRef) && !this.getEntityManager().contains((Object)a1)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception onfe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception :" + onfe);
            }
        } else {
            logger.log(System.Logger.Level.TRACE, "Instance is not managed- Unexpected");
            pass = false;
        }
        if (!pass) {
            throw new Exception("remove1X1Test6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1X1Test7() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin remove1X1Test7");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("7", "a7", 7);
            this.getEntityManager().persist((Object)a1);
            B bRef = new B("7", "a7", 7, a1);
            this.getEntityManager().persist((Object)bRef);
            logger.log(System.Logger.Level.TRACE, "get Instance ");
            A a2 = bRef.getA1();
            logger.log(System.Logger.Level.TRACE, "get Instance Status ");
            status = this.getEntityManager().contains((Object)bRef);
            if (status && a2 == a1) {
                logger.log(System.Logger.Level.TRACE, "Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)bRef);
                if (!this.getEntityManager().contains((Object)bRef)) {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1X1Test7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1X1Test8() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin remove1X1Test8");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("8", "a8", 8);
            this.getEntityManager().persist((Object)a1);
            B bRef = new B("8", "a8", 8, a1);
            this.getEntityManager().persist((Object)bRef);
            logger.log(System.Logger.Level.TRACE, "get Instance ");
            A a2 = bRef.getA1();
            logger.log(System.Logger.Level.TRACE, "get Instance Status ");
            status = this.getInstanceStatus(bRef);
            if (status && a2 == a1) {
                this.getEntityManager().remove((Object)bRef);
                if (!this.getEntityManager().contains((Object)a2)) {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1X1Test8 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1X1Test9() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin remove1X1Test9");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("9", "a9", 9);
            this.getEntityManager().persist((Object)a1);
            B bRef = new B("9", "b9", 9, a1);
            logger.log(System.Logger.Level.TRACE, "get Instance Status ");
            status = this.getEntityManager().contains((Object)a1);
            if (status) {
                logger.log(System.Logger.Level.TRACE, "A Entity is persisted, bRef is new, remove should be ignored on bRef, a1 should be removed");
                this.getEntityManager().remove((Object)bRef);
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.TRACE, "Call contains after remove()");
                status = this.getEntityManager().contains((Object)a1);
                logger.log(System.Logger.Level.TRACE, "Call contains after remove()");
                A stillExists = this.findA("9");
                if (!status && stillExists == null) {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("remove1X1Test9 failed");
        }
    }

    private A findA(String id) {
        logger.log(System.Logger.Level.TRACE, "Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private B findB(String id) {
        logger.log(System.Logger.Level.TRACE, "Entered findB method");
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private boolean getInstanceStatus(Object o) {
        logger.log(System.Logger.Level.TRACE, "Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

