/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.bindable;

import ee.jakarta.tck.persistence.common.PMClientBase;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "Address", pkgName + "ZipCode"};
        return this.createDeploymentJar("jpa_core_metamodelapi_bindable.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void getBindableType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Set of EntityType");
                for (EntityType eType : aSet) {
                    logger.log(System.Logger.Level.TRACE, "entity's BindableType is  = " + eType.getBindableType());
                    if (eType.getBindableType().equals((Object)Bindable.BindableType.ENTITY_TYPE)) {
                        logger.log(System.Logger.Level.TRACE, "as Expected BindableType is ENTITY_TYPE");
                        pass = true;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "bindableType is non ENTITY_TYPE");
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getBindableType failed");
        }
    }

    @Test
    public void getBindableJavaType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Set of EntityType");
                for (EntityType eType : aSet) {
                    logger.log(System.Logger.Level.TRACE, "entity's BindableJavaType is  = " + eType.getBindableJavaType().getName());
                    String bindableJavaType = eType.getBindableJavaType().getName();
                    if (bindableJavaType == null) continue;
                    if (bindableJavaType.equals("ee.jakarta.tck.persistence.core.metamodelapi.bindable.A")) {
                        logger.log(System.Logger.Level.TRACE, "as Expected BindableJavaType for A is " + bindableJavaType);
                        pass = true;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "bindableJavaType is incorrect");
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getBindableJavaType failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

