/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.setattribute;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.setattribute.A;
import ee.jakarta.tck.persistence.core.metamodelapi.setattribute.Address;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.Type;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "Address", pkgName + "ZipCode"};
        return this.createDeploymentJar("jpa_core_metamodelapi_setattribute.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void getSet() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(A.class);
            if (mType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SetAttribute setAttrib = mType.getSet("address", Address.class);
                Type t = setAttrib.getElementType();
                if (t != null) {
                    logger.log(System.Logger.Level.TRACE, "element Java Type  = " + t.getJavaType());
                    if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.setattribute.Address")) {
                        pass = true;
                    }
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getSet Test  failed");
        }
    }

    @Test
    public void getCollectionType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(A.class);
            if (mType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SetAttribute setAttrib = mType.getSet("address", Address.class);
                PluralAttribute.CollectionType setAttribColType = setAttrib.getCollectionType();
                logger.log(System.Logger.Level.TRACE, "collection Type = " + setAttrib.getCollectionType());
                if (setAttribColType == PluralAttribute.CollectionType.SET) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result = " + setAttribColType);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected result = " + setAttribColType);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getCollectionType Test  failed");
        }
    }

    @Test
    public void getElementType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mType = metaModel.managedType(A.class);
            if (mType != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                SetAttribute setAttrib = mType.getSet("address", Address.class);
                logger.log(System.Logger.Level.TRACE, "collection Element Type = " + setAttrib.getElementType().getJavaType().getName());
                String elementTypeName = setAttrib.getElementType().getJavaType().getName();
                if (elementTypeName.equals("ee.jakarta.tck.persistence.core.metamodelapi.setattribute.Address")) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result = " + elementTypeName);
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected result = " + elementTypeName);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getElementType Test  failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

