/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.persistenceUnitUtil;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.persistenceUnitUtil.Employee;
import ee.jakarta.tck.persistence.core.versioning.Member;
import jakarta.persistence.PersistenceUnitUtil;
import java.math.BigInteger;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private final Employee[] empRef = new Employee[2];

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Employee", Member.class.getName()};
        return this.createDeploymentJar("jpa_core_persistenceUtilUtil.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void getPersistenceUtilUtilTest() throws Exception {
        boolean pass = false;
        PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
        if (puu != null) {
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "getPersistenceUtil() returned null");
        }
        if (!pass) {
            throw new Exception("getPersistenceUtilUtilTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getIdentifierTest() throws Exception {
        Integer id;
        PersistenceUnitUtil puu;
        boolean pass = true;
        Employee emp = new Employee(1, "foo", "bar", this.getSQLDate("2000-02-14"), 35000.0f);
        logger.log(System.Logger.Level.INFO, "Test entity not yet persisted");
        try {
            puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            id = (Integer)puu.getIdentifier((Object)emp);
            if (id == null || id != 1) {
                logger.log(System.Logger.Level.ERROR, "expected a null or id: 1, actual id:" + id);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        logger.log(System.Logger.Level.INFO, "Test entity persisted");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)emp);
            puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            id = (Integer)puu.getIdentifier((Object)emp);
            if (id != 1) {
                logger.log(System.Logger.Level.ERROR, "expected a null or id: 1, actual id:" + id);
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("getIdentifierTest failed");
        }
    }

    @Test
    public void getIdentifierIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            puu.getIdentifier((Object)this);
            logger.log(System.Logger.Level.ERROR, "IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getIdentifierIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getVersionTest() throws Exception {
        boolean pass = false;
        boolean ID = true;
        Member member = new Member(1, "Member 1", true, BigInteger.valueOf(1000L));
        try {
            this.getEntityTransaction().begin();
            Member member1 = (Member)this.getEntityManager().find(Member.class, (Object)1);
            if (member1 != null) {
                this.getEntityManager().remove((Object)member1);
                this.getEntityTransaction().commit();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entity:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)member);
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            this.getEntityTransaction().commit();
            Integer version = (Integer)puu.getVersion((Object)member);
            if (version != null && version.equals(member.getVersion())) {
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("getVersionTest failed");
        }
    }

    @Test
    public void loadIsLoadTest() throws Exception {
        boolean pass = false;
        try {
            Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empRef[0].getId());
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            puu.load((Object)employee, "salary");
            if (puu.isLoaded((Object)employee, "salary")) {
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("loadIsLoadTest failed");
        }
    }

    @Test
    public void isInstanceTest() throws Exception {
        boolean pass = false;
        try {
            Employee foundEmployee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empRef[0].getId());
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            if (puu.isInstance((Object)foundEmployee, Employee.class)) {
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("isInstanceTest failed");
        }
    }

    @Test
    public void getClassTest() throws Exception {
        boolean pass = false;
        try {
            Employee foundEmployee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empRef[0].getId());
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            Class clazz = puu.getClass((Object)foundEmployee);
            if (clazz == Employee.class) {
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getClassTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "createTestData");
        try {
            this.getEntityTransaction().begin();
            this.empRef[0] = new Employee(100, "Alan", "Frechette", this.getSQLDate("2000-02-14"), 35000.0f);
            for (Employee e : this.empRef) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                logger.log(System.Logger.Level.TRACE, "persisted employee " + e);
            }
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.TRACE, "Created TestData");
        }
        catch (Exception re) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createTestData:", (Throwable)re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createTestData while rolling back TX:", (Throwable)re);
            }
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM MEMBER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

