/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.apitests;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.query.apitests.DataTypes2;
import ee.jakarta.tck.persistence.core.query.apitests.Department;
import ee.jakarta.tck.persistence.core.query.apitests.Employee;
import jakarta.persistence.Query;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client3
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client3.class.getName());
    private final Employee[] empRef = new Employee[21];
    private final java.sql.Date d1 = this.getSQLDate("2000-02-14");
    private final Date dateId = this.getUtilDate("2009-01-10");
    final Department[] deptRef = new Department[5];
    private static final DecimalFormat df = new DecimalFormat();

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client3.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DataTypes2", pkgName + "Department", pkgName + "Employee", pkgName + "Insurance"};
        return this.createDeploymentJar("jpa_core_query_apitests3.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupDataTypes2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createDataTypes2Data();
            logger.log(System.Logger.Level.TRACE, "Done creating test data");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception caught in Setup: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanupNoData() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "in cleanupNoData");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryAPITest28() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = true;
        Time timeValue = this.getTimeData("10:30:15");
        logger.log(System.Logger.Level.TRACE, "time Value = " + timeValue.toString());
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "FIND D2: " + this.dateId);
            DataTypes2 dataTypes2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != dataTypes2) {
                logger.log(System.Logger.Level.TRACE, "DataType Entity is not null, setting TimeData ");
                dataTypes2.setTimeData(timeValue);
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Null returned during initial find");
            }
            this.getEntityManager().merge((Object)dataTypes2);
            this.doFlush();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "Make sure update occurred");
            logger.log(System.Logger.Level.TRACE, "FIND D2 again:");
            dataTypes2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != dataTypes2) {
                if (dataTypes2.getTimeData().equals(timeValue)) {
                    logger.log(System.Logger.Level.TRACE, "Update occurred properly:" + dataTypes2);
                    pass2 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Update did not occur properly");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null after update");
            }
            logger.log(System.Logger.Level.TRACE, "Retrieving all results first");
            List cDataTypes2 = this.getEntityManager().createQuery("select d from DataTypes2 d").getResultList();
            for (DataTypes2 d : cDataTypes2) {
                logger.log(System.Logger.Level.TRACE, "result:" + d.toString());
            }
            logger.log(System.Logger.Level.TRACE, "Check results when testing for Time");
            List result = this.getEntityManager().createQuery("select d.timeData from DataTypes2 d where d.timeData = :time").setParameter("time", (Object)timeValue).getResultList();
            int result_size = result.size();
            logger.log(System.Logger.Level.TRACE, "Result Size = " + result_size);
            if (result_size == 1) {
                pass3 = true;
                logger.log(System.Logger.Level.TRACE, "Received expected result size");
                for (Time t : result) {
                    logger.log(System.Logger.Level.TRACE, "time=" + t);
                    if (t.equals(timeValue)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected Time ");
                        continue;
                    }
                    pass4 = false;
                    logger.log(System.Logger.Level.ERROR, "Received unexpected Time = " + t.toString());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected 1 result, instead got: " + result_size);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("queryAPITest28 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryAPITest29() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin queryAPITest29");
        int result_size = 0;
        boolean pass1 = false;
        boolean pass2 = true;
        Timestamp tsValue = this.getTimestampData("2006-11-11");
        logger.log(System.Logger.Level.TRACE, "timestamp Value = " + tsValue.toString());
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "FIND D2");
            DataTypes2 dataTypes2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != dataTypes2) {
                logger.log(System.Logger.Level.TRACE, "DataType Entity is not null, setting TimeData ");
                dataTypes2.setTsData(tsValue);
            }
            this.getEntityManager().merge((Object)dataTypes2);
            this.doFlush();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "Check results");
            if (null != dataTypes2) {
                Query q = this.getEntityManager().createQuery("select d.tsData from DataTypes2 d where d.tsData = {ts '2006-11-11 10:10:10'}");
                List result = q.getResultList();
                result_size = result.size();
                logger.log(System.Logger.Level.TRACE, "Result Size = " + result_size);
                if (result_size == 1) {
                    pass1 = true;
                    logger.log(System.Logger.Level.TRACE, "Received expected result size");
                    for (Timestamp t : result) {
                        logger.log(System.Logger.Level.TRACE, "time=" + t);
                        if (t.equals(tsValue)) {
                            logger.log(System.Logger.Level.TRACE, "Received expected TimeStamp ");
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "Received unexpected TimeStamp = " + t.toString());
                        pass2 = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + tsValue + " , got: " + dataTypes2.getTsData());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryAPITest29 failed");
        }
    }

    private void createDataTypes2Data() throws Exception {
        logger.log(System.Logger.Level.TRACE, "createDataTypes2Data");
        try {
            this.getEntityTransaction().begin();
            DataTypes2 dT2 = new DataTypes2(this.dateId);
            dT2.setDateData(this.dateId);
            dT2.setTimeData(this.getTimeData("01:01:01"));
            this.getEntityManager().persist((Object)dT2);
            Date d = this.getUtilDate("2010-02-11");
            dT2 = new DataTypes2(d);
            dT2.setDateData(d);
            dT2.setTimeData(this.getTimeData("02:02:02"));
            this.getEntityManager().persist((Object)dT2);
            d = this.getUtilDate("2011-03-12");
            dT2 = new DataTypes2(d);
            dT2.setDateData(d);
            dT2.setTimeData(this.getTimeData("03:03:03"));
            this.getEntityManager().persist((Object)dT2);
            d = this.getUtilDate("2012-04-01");
            dT2 = new DataTypes2(d);
            dT2.setDateData(d);
            dT2.setTimeData(this.getTimeData("04:04:04"));
            this.getEntityManager().persist((Object)dT2);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.TRACE, "Created TestData");
        }
        catch (Exception re) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createTestData:", (Throwable)re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createTestData while rolling back TX:", (Throwable)re);
            }
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM INSURANCE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

