/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.flushmode;

import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.UtilCustomerData;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.Query;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client1
extends UtilCustomerData {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_query_flushmode1.jar", pkgNameWithoutSuffix, classes);
    }

    @Test
    public void flushModeTest1() throws Exception {
        Customer newCust;
        String[] expectedPKs;
        List c;
        FlushModeType fmt;
        Query q;
        Customer cust1;
        EntityManager em;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        boolean pass6 = false;
        logger.log(System.Logger.Level.TRACE, "Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            em = this.getEntityManager();
            logger.log(System.Logger.Level.TRACE, "Calling find");
            cust1 = (Customer)em.find(Customer.class, (Object)"1");
            cust1.setName("Michael Bouschen");
            q = em.createQuery("SELECT c FROM Customer c WHERE c.name = 'Michael Bouschen'");
            logger.log(System.Logger.Level.TRACE, "EntityManager.getFlushMode() returned:" + em.getFlushMode());
            logger.log(System.Logger.Level.TRACE, "Calling Query.getFlushMode()");
            fmt = q.getFlushMode();
            if (!fmt.equals((Object)em.getFlushMode())) {
                logger.log(System.Logger.Level.ERROR, "getFlushMode() called when no mode set expected:" + em.getFlushMode() + ", actual:" + fmt);
            } else {
                pass1 = true;
                logger.log(System.Logger.Level.TRACE, "Setting mode to FlushModeType.AUTO");
                q.setFlushMode(FlushModeType.AUTO);
                fmt = q.getFlushMode();
                if (!fmt.equals((Object)FlushModeType.AUTO)) {
                    logger.log(System.Logger.Level.ERROR, "getFlushMode() called when no mode set expected:" + FlushModeType.AUTO + ", actual:" + fmt);
                } else {
                    pass2 = true;
                    c = q.getResultList();
                    if (!this.checkEntityPK(c, expectedPKs = new String[]{"1"})) {
                        logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 references, got: " + c.size());
                    } else {
                        newCust = (Customer)em.find(Customer.class, (Object)"1");
                        if (newCust.getName().equals("Michael Bouschen")) {
                            logger.log(System.Logger.Level.TRACE, "Expected results received");
                            pass3 = true;
                        }
                    }
                }
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
        }
        logger.log(System.Logger.Level.TRACE, "Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            em = this.getEntityManager();
            logger.log(System.Logger.Level.TRACE, "Calling find");
            cust1 = (Customer)em.find(Customer.class, (Object)"1");
            cust1.setName("Michael Bouschen");
            q = em.createQuery("SELECT c FROM Customer c WHERE c.name = 'Michael Bouschen'", Customer.class);
            logger.log(System.Logger.Level.TRACE, "Calling getFlushMode()");
            fmt = q.getFlushMode();
            if (!fmt.equals((Object)em.getFlushMode())) {
                logger.log(System.Logger.Level.ERROR, "getFlushMode() called when no mode set expected:" + em.getFlushMode() + ", actual:" + fmt);
            } else {
                pass4 = true;
                logger.log(System.Logger.Level.TRACE, "Setting mode to FlushModeType.AUTO");
                q.setFlushMode(FlushModeType.AUTO);
                fmt = q.getFlushMode();
                if (!fmt.equals((Object)FlushModeType.AUTO)) {
                    logger.log(System.Logger.Level.ERROR, "getFlushMode() called when no mode set expected:" + FlushModeType.AUTO + ", actual:" + fmt);
                } else {
                    pass5 = true;
                    c = q.getResultList();
                    if (!this.checkEntityPK(c, expectedPKs = new String[]{"1"})) {
                        logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 references, got: " + c.size());
                    } else {
                        newCust = (Customer)em.find(Customer.class, (Object)"1");
                        if (newCust.getName().equals("Michael Bouschen")) {
                            pass6 = true;
                            logger.log(System.Logger.Level.TRACE, "Expected results received");
                        }
                    }
                }
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6)) {
            throw new Exception("flushModeTest1 failed");
        }
    }
}

