/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.se.pluggability.contracts.resource_local;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.EntityManagerFactoryImpl;
import ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.EntityManagerImpl;
import ee.jakarta.tck.persistence.common.pluggability.util.LogFileProcessor;
import ee.jakarta.tck.persistence.common.pluggability.util.LogRecordEntry;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Persistence;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final long serialVersionUID = 1L;
    private Properties props = null;
    private static EntityManager em;
    private static EntityManager alt_em;
    private transient EntityManagerImpl emImpl;
    private transient EntityManagerFactoryImpl emfImpl;
    private PersistenceUnitInfo puInfo;
    private long currentSeqNum = 0L;
    private static LogFileProcessor logProcessor;
    private String LOGMESSAGE_PREFIX = "JPA_ALTERNATE_PROVIDER : ";
    private boolean pluggabilityJarDeployed = false;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFile = new String[]{"myMappingFile1.xml", "myMappingFile2.xml", "orm.xml"};
        String[] classes = new String[]{pkgName + "Order", pkgName + "Order2", pkgName + "Order3", pkgName + "Order4", pkgName + "Order5", LogFileProcessor.class.getCanonicalName(), LogRecordEntry.class.getCanonicalName()};
        return this.createDeploymentJar("jpa_se_pluggability_contracts_resource_local.jar", pkgNameWithoutSuffix, classes, "persistence.xml", xmlFile);
    }

    public void removePluggabilityJarFromCP() throws Exception {
        if (this.pluggabilityJarDeployed) {
            URLClassLoader currentThreadClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader.getParent());
            currentThreadClassLoader.close();
            this.pluggabilityJarDeployed = false;
        }
    }

    public JavaArchive createPluggabilityJar() throws Exception {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jpa_alternate_provider.jar");
        archive.addPackages(true, new String[]{"ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation"});
        InputStream inStream = Client.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/persistence/common/pluggability/altprovider/METAINF/services/jakarta.persistence.spi.PersistenceProvider");
        StringAsset containerProvider = new StringAsset(Client.toString((InputStream)inStream));
        archive.addAsManifestResource((Asset)containerProvider, "services/jakarta.persistence.spi.PersistenceProvider");
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(new File(TEMP_DIR + File.separator + "jpa_alternate_provider.jar"), true);
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{new File(TEMP_DIR + File.separator + "jpa_alternate_provider.jar").toURL()}, currentThreadClassLoader);
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        this.pluggabilityJarDeployed = true;
        return archive;
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        super.setup();
        this.createDeployment();
        this.createPluggabilityJar();
        this.initEntityManager("ALTPROVIDERPU", false);
    }

    public void getLogProcessor() {
        logProcessor = new LogFileProcessor();
        logProcessor.fetchLog();
    }

    @Test
    public void getPersistenceProviderClassName() throws Exception {
        boolean pass1 = false;
        String expected1 = "ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.PersistenceProvider";
        this.getClassObjects();
        String actual = this.puInfo.getPersistenceProviderClassName();
        if (actual.equals(expected1)) {
            logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual);
            pass1 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected: " + expected1 + ", actual:" + actual);
        }
        this.getLogProcessor();
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getPersistenceProviderClassName()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2);
        if (!pass1 || !pass2) {
            throw new Exception("getPersistenceProviderClassName failed");
        }
    }

    @Test
    public void getPersistenceUnitNameTest() throws Exception {
        boolean pass1 = false;
        ArrayList<String> expected1 = new ArrayList<String>();
        expected1.add("ALTPROVIDERPU");
        this.getClassObjects();
        String actual = this.puInfo.getPersistenceUnitName();
        if (expected1.contains(actual)) {
            logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual);
            pass1 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Did not get one of the expected results");
            logger.log(System.Logger.Level.ERROR, "Expected:");
            for (String s : expected1) {
                logger.log(System.Logger.Level.ERROR, s);
            }
            logger.log(System.Logger.Level.ERROR, "actual:" + actual);
        }
        this.getLogProcessor();
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getPersistenceUnitName()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2);
        if (!pass1 || !pass2) {
            throw new Exception("getPersistenceUnitNameTest failed");
        }
    }

    @Test
    public void getTransactionType() throws Exception {
        boolean pass1 = false;
        this.getClassObjects();
        PersistenceUnitTransactionType expected1 = null;
        expected1 = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        PersistenceUnitTransactionType actual = this.puInfo.getTransactionType();
        if (actual.equals((Object)expected1)) {
            pass1 = true;
            logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.toString());
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected: " + expected1.name() + ", actual:" + actual.name());
        }
        this.getLogProcessor();
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getTransactionType()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2);
        if (!pass1 || !pass2) {
            throw new Exception("getTransactionType failed");
        }
    }

    @Test
    public void getManagedClassNames() throws Exception {
        boolean pass1 = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("com.foo");
        this.getClassObjects();
        List actual = this.puInfo.getManagedClassNames();
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            pass1 = true;
            logger.log(System.Logger.Level.TRACE, "Received expected result:" + (String)actual.get(0));
        } else {
            logger.log(System.Logger.Level.ERROR, "Did not get expected ManagedClassNames");
            logger.log(System.Logger.Level.ERROR, "Expected:");
            for (String s : expected) {
                logger.log(System.Logger.Level.ERROR, s);
            }
            logger.log(System.Logger.Level.ERROR, "Actual:");
            for (String s : actual) {
                logger.log(System.Logger.Level.ERROR, s);
            }
        }
        this.getLogProcessor();
        String[] expected1 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getManagedClassNames()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected1);
        if (!pass1 || !pass2) {
            throw new Exception("getManagedClassNames failed");
        }
    }

    @Test
    public void getJarFileUrls() throws Exception {
        boolean pass1 = false;
        String expected1 = "pluggability_contracts_resource_local.jar";
        this.getClassObjects();
        List actual = this.puInfo.getJarFileUrls();
        if (actual.size() > 0) {
            for (URL u : actual) {
                String sURL = u.toString();
                if (sURL.contains(expected1)) {
                    logger.log(System.Logger.Level.TRACE, "actual:" + sURL);
                    pass1 = true;
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "getJarFileUrls() did not return a URL that contains:" + expected1);
                logger.log(System.Logger.Level.TRACE, "actual:" + sURL);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getJarFileUrls() returned no results");
        }
        this.getLogProcessor();
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getJarFileUrls()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2);
        if (!pass1 || !pass2) {
            throw new Exception("getJarFileUrls failed");
        }
    }

    @Test
    public void getPersistenceUnitRootUrl() throws Exception {
        boolean pass1 = false;
        String expected1 = "pluggability_contracts_resource_local.jar";
        this.getClassObjects();
        URL actual = this.puInfo.getPersistenceUnitRootUrl();
        if (actual.toString().contains(expected1)) {
            logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.toString());
            pass1 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected the actual to contain:" + expected1);
            logger.log(System.Logger.Level.ERROR, "actual: " + actual.toString());
        }
        this.getLogProcessor();
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getPersistenceUnitRootUrl()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2);
        if (!pass1 || !pass2) {
            throw new Exception("getPersistenceUnitRootUrl failed");
        }
    }

    @Test
    public void getPersistenceXMLSchemaVersion() throws Exception {
        boolean pass1 = false;
        String expected1 = "3.2";
        this.getClassObjects();
        String actual = this.puInfo.getPersistenceXMLSchemaVersion();
        if (actual.toString().equals(expected1)) {
            logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.toString());
            pass1 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "expected: " + expected1);
            logger.log(System.Logger.Level.ERROR, "actual: " + actual.toString());
        }
        this.getLogProcessor();
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getPersistenceXMLSchemaVersion()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2);
        if (!pass1 || !pass2) {
            throw new Exception("getPersistenceXMLSchemaVersion failed");
        }
    }

    @Test
    public void getProperties() throws Exception {
        boolean pass1 = true;
        Properties expected1 = new Properties();
        expected1.put("eclipselink.logging.level", "INFO");
        expected1.put("eclipselink.logging.logger", "DefaultLogger");
        this.getClassObjects();
        Properties actual = this.puInfo.getProperties();
        if (!actual.isEmpty()) {
            for (Map.Entry<Object, Object> e : expected1.entrySet()) {
                String eKey = (String)e.getKey();
                String eVal = (String)e.getValue();
                logger.log(System.Logger.Level.TRACE, "key:" + eKey + ", value:" + eVal);
                if (!actual.containsKey(eKey)) continue;
                String aVal = (String)actual.get(eKey);
                if (aVal.equals(eVal)) {
                    logger.log(System.Logger.Level.TRACE, "Found expected result:" + eKey + "," + eVal);
                    continue;
                }
                pass1 = false;
                logger.log(System.Logger.Level.ERROR, "Actual did not contain expected property:" + eKey + "," + eVal);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getProperties() returned no properties");
        }
        if (!pass1) {
            String value;
            String key;
            logger.log(System.Logger.Level.ERROR, "Expected:");
            for (Map.Entry<Object, Object> e : expected1.entrySet()) {
                key = (String)e.getKey();
                value = (String)e.getValue();
                logger.log(System.Logger.Level.ERROR, "key:" + key + ", value:" + value);
            }
            logger.log(System.Logger.Level.ERROR, "Actual:");
            for (Map.Entry<Object, Object> e : actual.entrySet()) {
                key = (String)e.getKey();
                value = (String)e.getValue();
                logger.log(System.Logger.Level.ERROR, "key:" + key + ", value:" + value);
            }
        }
        this.getLogProcessor();
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getProperties()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected);
        if (!pass1 || !pass2) {
            throw new Exception("getProperties failed");
        }
    }

    @Test
    public void getSharedCacheMode() throws Exception {
        boolean pass1 = false;
        SharedCacheMode expected1 = SharedCacheMode.NONE;
        this.getClassObjects();
        SharedCacheMode actual = this.puInfo.getSharedCacheMode();
        if (actual.equals((Object)expected1)) {
            logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.name());
            pass1 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "expected: " + expected1.name());
            logger.log(System.Logger.Level.ERROR, "actual: " + actual.name());
        }
        this.getLogProcessor();
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getSharedCacheMode()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2);
        if (!pass1 || !pass2) {
            throw new Exception("getSharedCacheMode failed");
        }
    }

    @Test
    public void getValidationMode() throws Exception {
        boolean pass1 = false;
        ValidationMode expected1 = ValidationMode.NONE;
        this.getClassObjects();
        ValidationMode actual = this.puInfo.getValidationMode();
        if (actual.equals((Object)expected1)) {
            logger.log(System.Logger.Level.TRACE, "Received expected result:" + actual.name());
            pass1 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "expected: " + expected1.name());
            logger.log(System.Logger.Level.ERROR, "actual: " + actual.name());
        }
        this.getLogProcessor();
        String[] expected2 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getValidationMode()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected2);
        if (!pass1 || !pass2) {
            throw new Exception("getValidationMode failed");
        }
    }

    @Test
    public void getClassLoader() throws Exception {
        boolean pass1 = false;
        this.getClassObjects();
        ClassLoader actual = this.puInfo.getClassLoader();
        if (actual != null) {
            pass1 = true;
            logger.log(System.Logger.Level.TRACE, "Received expected non null ClassLoader:" + actual.toString());
        } else {
            logger.log(System.Logger.Level.ERROR, "Received null ClassLoader");
        }
        this.getLogProcessor();
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getClassLoader()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected);
        if (!pass1 || !pass2) {
            throw new Exception("getClassLoader failed");
        }
    }

    @Test
    public void getMappingFileNames() throws Exception {
        boolean pass1 = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("META-INF/myMappingFile1.xml");
        expected.add("META-INF/myMappingFile2.xml");
        this.getClassObjects();
        List actual = this.puInfo.getMappingFileNames();
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            pass1 = true;
            logger.log(System.Logger.Level.TRACE, "Received expected result:");
            for (String s : actual) {
                logger.log(System.Logger.Level.TRACE, "result:" + s);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Did not get expected ManagedClassNames");
            logger.log(System.Logger.Level.ERROR, "Expected:");
            for (String s : expected) {
                logger.log(System.Logger.Level.ERROR, s);
            }
            logger.log(System.Logger.Level.ERROR, "Actual:");
            for (String s : actual) {
                logger.log(System.Logger.Level.ERROR, s);
            }
        }
        this.getLogProcessor();
        String[] expected1 = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.getMappingFileNames()"};
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected1);
        if (!pass1 || !pass2) {
            throw new Exception("getMappingFileNames failed");
        }
    }

    @Test
    public void excludeUnlistedClasses() throws Exception {
        boolean pass1 = false;
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called PersistenceUnitInfoImpl.excludeUnlistedClasses()"};
        this.getClassObjects();
        if (!this.puInfo.excludeUnlistedClasses()) {
            logger.log(System.Logger.Level.TRACE, "excludeUnlistedClasses() returned expected result:" + this.puInfo.excludeUnlistedClasses());
            pass1 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "excludeUnlistedClasses() returned null result");
        }
        this.getLogProcessor();
        logProcessor.fetchLog();
        boolean pass2 = logProcessor.verifyLogContains(expected);
        if (!pass1 || !pass2) {
            throw new Exception("excludeUnlistedClasses failed");
        }
    }

    @Test
    public void getProviderUtil() throws Exception {
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called getProviderUtil()"};
        Persistence.getPersistenceUtil().isLoaded((Object)"Order");
        this.getLogProcessor();
        logProcessor.fetchLog();
        boolean pass = logProcessor.verifyLogContains(expected);
        if (!pass) {
            throw new Exception("getProviderUtil failed");
        }
    }

    @Test
    public void isLoaded() throws Exception {
        String[] expected = new String[]{this.LOGMESSAGE_PREFIX + "Called isLoaded()"};
        Persistence.getPersistenceUtil().isLoaded((Object)"Order");
        this.getLogProcessor();
        logProcessor.fetchLog();
        boolean pass = logProcessor.verifyLogContains(expected);
        if (!pass) {
            throw new Exception("isLoaded failed");
        }
    }

    public void getClassObjects() {
        this.emImpl = (EntityManagerImpl)this.getEntityManager(false).unwrap(EntityManagerImpl.class);
        this.emfImpl = (EntityManagerFactoryImpl)this.emImpl.getEntityManagerFactory();
        this.puInfo = this.emfImpl.puInfo;
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            logger.log(System.Logger.Level.TRACE, "calling super.cleanup");
            super.cleanup();
            this.removeTestJarFromCP();
        }
        finally {
            this.removePluggabilityJarFromCP();
        }
    }

    static {
        logProcessor = null;
    }
}

