/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.signaturetest;

import com.sun.ts.tests.signaturetest.SigTest;
import com.sun.ts.tests.signaturetest.SignatureTestDriver;
import com.sun.ts.tests.signaturetest.SignatureTestDriverFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.junit.jupiter.api.Test;

public class JPASigTest
extends SigTest {
    private static final System.Logger logger = System.getLogger(JPASigTest.class.getName());

    public JPASigTest() {
        this.setup();
    }

    protected String[] getPackages() {
        return new String[]{"jakarta.persistence", "jakarta.persistence.criteria", "jakarta.persistence.metamodel", "jakarta.persistence.spi"};
    }

    @Test
    public void signatureTest() throws Exception {
        logger.log(System.Logger.Level.INFO, "$$$ SigTestIT.signatureTest() called");
        String mapFile = null;
        String packageFile = null;
        Object repositoryDir = null;
        Properties mapFileAsProps = null;
        String[] packages = this.getPackages();
        String apiPackage = "jakarta.persistence";
        try {
            InputStream inStreamMapfile = JPASigTest.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/persistence/signaturetest/sig-test.map");
            File mFile = this.writeStreamToTempFile(inStreamMapfile, "sig-test", ".map");
            mapFile = mFile.getCanonicalPath();
            logger.log(System.Logger.Level.INFO, "mapFile location is :" + mapFile);
            InputStream inStreamPackageFile = JPASigTest.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/persistence/signaturetest/sig-test-pkg-list.txt");
            File pFile = this.writeStreamToTempFile(inStreamPackageFile, "sig-test-pkg-list", ".txt");
            packageFile = pFile.getCanonicalPath();
            logger.log(System.Logger.Level.INFO, "packageFile location is :" + packageFile);
            mapFileAsProps = this.getSigTestDriver().loadMapFile(mapFile);
            String packageVersion = mapFileAsProps.getProperty(apiPackage);
            logger.log(System.Logger.Level.INFO, "Package version from mapfile :" + packageVersion);
            InputStream inStreamSigFile = JPASigTest.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/persistence/signaturetest/jakarta.persistence.sig_" + packageVersion);
            File sigFile = this.writeStreamToSigFile(inStreamSigFile, apiPackage, packageVersion);
            logger.log(System.Logger.Level.INFO, "signature File location is :" + sigFile.getCanonicalPath());
        }
        catch (IOException ex) {
            logger.log(System.Logger.Level.ERROR, "Exception while creating temp files :" + ex);
        }
        super.signatureTest(mapFile, packageFile, mapFileAsProps, packages);
    }

    protected SignatureTestDriver getSigTestDriver() {
        this.driver = SignatureTestDriverFactory.getInstance((String)"sigtest");
        return this.driver;
    }
}

