/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.endpoint.server;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.endpoint.server.WSCMsgServer;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;

public class WSCCloseServerEndpoint
extends Endpoint
implements MessageHandler.Whole<String> {
    private Session session;
    static final String CLOSE = "@OnClose";

    public void onMessage(String msg) {
        try {
            this.session.getBasicRemote().sendText(msg);
        }
        catch (IOException e) {
            this.onError(this.session, e);
        }
    }

    public void onOpen(Session session, EndpointConfig config) {
        session.addMessageHandler((MessageHandler)this);
        this.session = session;
    }

    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
        WSCMsgServer.setLastMessage(CLOSE);
    }

    public void onError(Session session, Throwable t) {
        super.onError(session, t);
        t.printStackTrace();
        String message = IOUtil.printStackTrace(t);
        try {
            session.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

