/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.unimanyxmany;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.unimanyxmany.UniMXMPerson;
import ee.jakarta.tck.persistence.core.relationship.unimanyxmany.UniMXMProject;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uniMXMTest1() throws Exception {
        this.logTrace("Begin uniMXMTest1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            UniMXMProject project1 = new UniMXMProject(1L, "JavaEE", Float.valueOf(500.0f));
            UniMXMProject project2 = new UniMXMProject(2L, "Identity", Float.valueOf(300.0f));
            UniMXMPerson person1 = new UniMXMPerson(1L, "Duke");
            UniMXMPerson person2 = new UniMXMPerson(2L, "Foo");
            this.getEntityManager().persist((Object)project1);
            this.getEntityManager().persist((Object)project2);
            this.getEntityManager().persist((Object)person1);
            this.getEntityManager().persist((Object)person2);
            Vector<UniMXMProject> projects = new Vector<UniMXMProject>();
            projects.add(project1);
            projects.add(project2);
            person1.setProjects(projects);
            Vector<UniMXMProject> projects2 = new Vector<UniMXMProject>();
            projects2.add(project2);
            person2.setProjects(projects2);
            this.getEntityManager().merge((Object)person1);
            this.getEntityManager().merge((Object)person2);
            this.logTrace("persisted Persons and Project");
            boolean pass1 = false;
            boolean pass2 = false;
            UniMXMPerson newPerson = (UniMXMPerson)this.getEntityManager().find(UniMXMPerson.class, (Object)1L);
            if (newPerson != null) {
                Collection<UniMXMProject> newProjects = newPerson.getProjects();
                for (UniMXMProject prj : newProjects) {
                    if (prj.getName().equals("Identity")) {
                        pass1 = true;
                        continue;
                    }
                    if (!prj.getName().equals("JavaEE")) continue;
                    pass2 = true;
                }
            }
            boolean pass3 = false;
            UniMXMPerson newPerson2 = (UniMXMPerson)this.getEntityManager().find(UniMXMPerson.class, (Object)2L);
            if (newPerson2 != null) {
                Collection<UniMXMProject> newProjects2 = newPerson2.getProjects();
                for (UniMXMProject prj : newProjects2) {
                    if (!prj.getName().equals("Identity")) continue;
                    pass3 = true;
                }
            }
            if (pass1 && pass2 && pass3) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("uniMXMTest1 failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM UNIMXMPERSON_UNIMXMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UNIMXMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UNIMXMPERSON").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

