/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.collectiontable;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.collectiontable.A;
import ee.jakarta.tck.persistence.core.annotations.collectiontable.Address;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectionTable1() throws Exception {
        this.logTrace("Begin collectionTable1");
        boolean pass = false;
        A aRef = null;
        Object bCol = null;
        Object newCol = null;
        try {
            this.logTrace("New instances");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA", "01801");
            Address addr2 = new Address("Some Address", "Boston", "MA", "01803");
            HashSet<Address> s1 = new HashSet<Address>();
            s1.add(addr1);
            s1.add(addr2);
            aRef = new A("1", "bean1", 1);
            aRef.setAddress(s1);
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)aRef);
            this.getEntityTransaction().commit();
            this.getEntityTransaction().begin();
            A newA = this.findA("1");
            Set<Address> newAddressSet = newA.getAddress();
            this.dumpAddresses(newAddressSet);
            boolean pass1 = false;
            boolean pass2 = false;
            for (Address addr : newAddressSet) {
                if (addr.getStreet().equals("1 Network Drive") && addr.getCity().equals("Burlington") && addr.getState().equals("MA") && addr.getZip().equals("01801")) {
                    pass1 = true;
                    this.logTrace("pass1 = " + pass1);
                }
                if (!addr.getStreet().equals("Some Address") || !addr.getCity().equals("Boston") || !addr.getState().equals("MA") || !addr.getZip().equals("01803")) continue;
                pass2 = true;
                this.logTrace("pass2 = " + pass2);
            }
            if (pass1 && pass2) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("collectionTable1 failed");
        }
    }

    private A findA(String id) {
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private void dumpAddresses(Set<Address> addr) {
        this.logTrace("address Data");
        this.logTrace("---------------");
        this.logTrace("size=" + addr.size());
        int elem = 1;
        for (Address v : addr) {
            this.logTrace("- Element #" + elem++);
            if (v != null) {
                this.logTrace("  street=" + v.getStreet() + ", city=" + v.getCity() + ", state=" + v.getState() + ", zip=" + v.getZip());
                continue;
            }
            this.logTrace("  address=numm");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from COLTAB_ADDRESS").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from COLTAB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

