/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.remove.basic;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.remove.basic.A;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBasicTest1() throws Exception {
        this.logTrace("Begin removeBasicTest1");
        boolean pass = false;
        A a1 = new A("1", "a1", 1);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().remove((Object)a1);
            pass = true;
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            this.logErr("Unexpected Exception during remove operation.  Should have been ignored.", fe);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("removeBasicTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBasicTest2() throws Exception {
        this.logTrace("Begin removeBasicTest2");
        boolean pass = false;
        A a1 = new A("2", "a2", 2);
        this.createA(a1);
        this.getEntityTransaction().begin();
        try {
            A newA = this.findA("2");
            this.getEntityManager().remove((Object)newA);
            this.logTrace("Call contains after remove()");
            pass = !this.getEntityManager().contains((Object)newA);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("removeBasicTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBasicTest3() throws Exception {
        A a1 = new A("4", "a4", 4);
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Persist Instance");
            this.getEntityManager().persist((Object)a1);
            if (this.getEntityManager().contains((Object)a1)) {
                try {
                    this.getEntityManager().remove((Object)a1);
                    this.getEntityManager().flush();
                    A stillExists = this.findA("4");
                    if (stillExists == null) {
                        this.getEntityManager().remove((Object)a1);
                        pass = true;
                    }
                }
                catch (Exception e) {
                    this.logErr("Unexpected exception caught trying to remove a removed entity, should have been ignored", e);
                    pass = false;
                }
            } else {
                this.logTrace("entity not managed, unexpected, test fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("removeBasicTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBasicTest4() throws Exception {
        this.logTrace("Begin removeBasicTest4");
        boolean pass = false;
        A a1 = new A("5", "a5", 5);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a1);
        try {
            A newA = this.findA("5");
            if (null != newA) {
                this.logTrace("Found newA, try Remove");
                this.getEntityManager().remove((Object)newA);
                this.getEntityManager().flush();
                this.logTrace("Removed, try to find and verify the entity has been removed");
                newA = this.findA("5");
                if (null == newA) {
                    this.logTrace("NewA is Null as expected");
                    pass = true;
                }
            } else {
                this.logErr("Could not find persisted entity.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception attempting to find removed entity:" + e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("removeBasicTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBasicTest5() throws Exception {
        this.logTrace("Begin removeBasicTest5");
        boolean pass = false;
        A a1 = new A("6", "a6", 6);
        this.createA(a1);
        try {
            this.getEntityTransaction().begin();
            A a2 = this.findA("6");
            this.getEntityManager().remove((Object)a2);
            if (!this.getEntityManager().contains((Object)a2)) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception caught:" + e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("removeBasicTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMergeBasicTest() throws Exception {
        this.logTrace("Begin removeMergeBasicTest");
        boolean pass = false;
        String reason = null;
        String aId = "7";
        A a1 = new A("7", "a7", 7);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().flush();
            this.getEntityManager().remove((Object)a1);
            try {
                this.getEntityManager().merge((Object)a1);
            }
            catch (IllegalArgumentException e) {
                this.logTrace("Got expected exception when merging a removed entity:" + e);
                pass = true;
            }
            if (!pass) {
                this.getEntityTransaction().commit();
            }
        }
        catch (Exception e) {
            this.logTrace("This exception may be expected, but we need to check if the commit really failed:" + e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            A aFound = this.findA("7");
            if (aFound == null) {
                pass = true;
                this.logTrace("No entity with id 7 was found.  The commit must have failed, as expected.");
            } else {
                reason = "Entity with id 7 was found: " + aFound + ".  It means the previous commit unexpectedly succeeded.";
                this.logTrace(reason);
            }
        }
        if (!pass) {
            throw new Exception("removeMergeBasicTest failed, reason: " + reason);
        }
    }

    private void createA(A a) {
        this.logTrace("Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    private A findA(String id) {
        this.logTrace("Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

