/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.parameter;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.core.criteriaapi.parameter.Client;
import ee.jakarta.tck.persistence.core.criteriaapi.parameter.Employee;
import jakarta.persistence.Parameter;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Properties;

public class Client1
extends Client {
    public static void main(String[] args) {
        Client1 theTests = new Client1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.getEntityManager();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void parameterTest1() throws Exception {
        this.logTrace("Starting parameterTest1");
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        boolean pass6 = false;
        boolean pass7 = false;
        boolean pass8 = false;
        boolean pass9 = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
        if (cquery != null) {
            Root employee = cquery.from(Employee.class);
            cquery.select((Selection)employee);
            ArrayList<Predicate> criteria = new ArrayList<Predicate>();
            ParameterExpression pe = qbuilder.parameter(String.class, "first");
            Class c = pe.getParameterType();
            if (c.isAssignableFrom(String.class)) {
                this.logTrace("Received expected type from getParameterType()");
                pass1 = true;
            } else {
                this.logErr("Expected type String from getParameterType(), instead got:" + c);
            }
            String name = pe.getName();
            if (name != null) {
                if (!name.equals("first")) {
                    this.logErr("getName() returned wrong name, expected: first, actual:" + name);
                } else {
                    pass2 = true;
                }
            } else {
                this.logErr("getName() returned null");
            }
            Integer position = pe.getPosition();
            if (position != null) {
                this.logErr("getPosition() returned:" + position + ", instead of null");
            } else {
                pass3 = true;
            }
            ParameterExpression pe2 = qbuilder.parameter(String.class, "last");
            criteria.add(qbuilder.equal((Expression)employee.get("firstName"), (Expression)pe));
            criteria.add(qbuilder.equal((Expression)employee.get("lastName"), (Expression)pe2));
            cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            ArrayList list = new ArrayList(q.getParameters());
            for (int i = 0; i < list.size(); ++i) {
                Parameter p = (Parameter)list.get(i);
                this.logTrace("parameter name = " + p.getName());
                this.logTrace("parameter position = " + p.getPosition());
                this.logTrace("parameter type =" + p.getParameterType());
            }
            String sExpected = "first";
            Parameter p1 = q.getParameter(sExpected);
            String sActual = p1.getName();
            if (!sActual.equals(sExpected)) {
                this.logErr("p1.getName() - Expected: " + sExpected + ", actual:" + sActual);
            } else {
                pass4 = true;
            }
            sExpected = null;
            Integer iActual = p1.getPosition();
            if (iActual != null) {
                this.logErr("p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual);
            } else {
                pass5 = true;
            }
            sExpected = "java.lang.String";
            sActual = p1.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                this.logErr("p1.getParameterType() - Expected: " + sExpected + ", actual:" + sActual);
            } else {
                pass6 = true;
            }
            sExpected = "last";
            Parameter p2 = q.getParameter(sExpected);
            sActual = p2.getName();
            if (!sActual.equals(sExpected)) {
                this.logErr("p2.getName() - Expected: " + sExpected + ", actual:" + sActual);
            } else {
                pass7 = true;
            }
            sExpected = null;
            iActual = p2.getPosition();
            if (iActual != null) {
                this.logErr("p2.getPosition() - Expected: " + sExpected + ", actual:" + iActual);
            } else {
                pass8 = true;
            }
            sExpected = "java.lang.String";
            sActual = p2.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                this.logErr("p2.getParameterType() - Expected: " + sExpected + ", actual:" + sActual);
            } else {
                pass9 = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7 && pass8 && pass9)) {
            throw new Exception("parameterTest1 test failed");
        }
    }

    public void parameterTest2() throws Exception {
        this.logTrace("Starting parameterTest2");
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
        if (cquery != null) {
            Root employee = cquery.from(Employee.class);
            cquery.select((Selection)employee);
            ArrayList<Predicate> criteria = new ArrayList<Predicate>();
            ParameterExpression pe = qbuilder.parameter(Float.class, "salary");
            criteria.add(qbuilder.equal((Expression)employee.get("salary"), (Expression)pe));
            cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            ArrayList list = new ArrayList(q.getParameters());
            for (int i = 0; i < list.size(); ++i) {
                Parameter p = (Parameter)list.get(i);
                this.logTrace("parameter name = " + p.getName());
                this.logTrace("parameter position = " + p.getPosition());
                this.logTrace("parameter type =" + p.getParameterType());
            }
            String sExpected = "salary";
            Parameter p1 = q.getParameter(sExpected);
            String sActual = p1.getName();
            if (!sActual.equals(sExpected)) {
                this.logErr("p1.getName() - Expected: " + sExpected + ", actual:" + sActual);
            } else {
                pass1 = true;
            }
            sExpected = null;
            Integer iActual = p1.getPosition();
            if (iActual != null) {
                this.logErr("p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual);
            } else {
                pass2 = true;
            }
            sExpected = "java.lang.Float";
            sActual = p1.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                this.logErr("p1.getParameterType() - Expected: " + sExpected + ", actual:" + sActual);
            } else {
                pass3 = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("parameterTest2 test failed");
        }
    }

    public void parameterTest3() throws Exception {
        this.logTrace("Starting parameterTest3");
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
        if (cquery != null) {
            Root employee = cquery.from(Employee.class);
            cquery.select((Selection)employee);
            ArrayList<Predicate> criteria = new ArrayList<Predicate>();
            ParameterExpression pe = qbuilder.parameter(Date.class, "hdate");
            criteria.add(qbuilder.equal((Expression)employee.get("hireDate"), (Expression)pe));
            cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            ArrayList list = new ArrayList(q.getParameters());
            for (int i = 0; i < list.size(); ++i) {
                Parameter p = (Parameter)list.get(i);
                this.logTrace("parameter name = " + p.getName());
                this.logTrace("parameter position = " + p.getPosition());
                this.logTrace("parameter type =" + p.getParameterType());
            }
            String sExpected = "hdate";
            Parameter p1 = q.getParameter(sExpected);
            String sActual = p1.getName();
            if (!sActual.equals(sExpected)) {
                this.logErr("p1.getName() - Expected: " + sExpected + ", actual:" + sActual);
            } else {
                pass1 = true;
            }
            sExpected = null;
            Integer iActual = p1.getPosition();
            if (iActual != null) {
                this.logErr("p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual);
            } else {
                pass2 = true;
            }
            sExpected = "java.sql.Date";
            sActual = p1.getParameterType().getName();
            if (!sActual.equals(sExpected)) {
                this.logErr("p1.getParameterType() - Expected: " + sExpected + ", actual:" + sActual);
            } else {
                pass3 = true;
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("parameterTest3 test failed");
        }
    }

    public void parameterTest4() throws Exception {
        this.logTrace("Starting parameterTest4");
        boolean pass1 = false;
        boolean pass2 = true;
        CriteriaBuilder qbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
        if (cquery != null) {
            Parameter p;
            int i;
            Root employee = cquery.from(Employee.class);
            cquery.select((Selection)employee);
            ArrayList<Predicate> criteria = new ArrayList<Predicate>();
            ParameterExpression pe = qbuilder.parameter(String.class);
            criteria.add(qbuilder.equal((Expression)employee.get("firstName"), (Expression)pe));
            cquery.where((Expression)qbuilder.or(criteria.toArray(new Predicate[0])));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            ArrayList list = new ArrayList(q.getParameters());
            for (i = 0; i < list.size(); ++i) {
                p = (Parameter)list.get(i);
                this.logTrace("parameter position = " + p.getPosition());
                this.logTrace("parameter type =" + p.getParameterType());
            }
            for (i = 0; i < list.size(); ++i) {
                p = (Parameter)list.get(i);
                pass1 = true;
                String sExpected = null;
                Integer iActual = p.getPosition();
                if (iActual != null) {
                    this.logErr("p1.getPosition() - Expected: " + sExpected + ", actual:" + iActual);
                }
                sExpected = "java.lang.String";
                String sActual = p.getParameterType().getName();
                if (sActual.equals(sExpected)) continue;
                this.logErr("p1.getParameterType() - Expected: " + sExpected + ", actual:" + sActual);
            }
        } else {
            this.logErr("Failed to get Non-null Criteria Query");
        }
        if (!pass1 || !pass2) {
            throw new Exception("parameterTest4 test failed");
        }
    }
}

