/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManagerFactory;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entityManagerFactory.Member;
import java.util.Properties;

public class Client4
extends PMClientBase {
    public static void main(String[] args) {
        Client4 theTests = new Client4();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void cleanup() throws Exception {
        super.cleanup();
    }

    public void callInTransactionTest() throws Exception {
        int MEMBER_ID = 10;
        boolean pass = false;
        try {
            Member member = (Member)this.getEntityManager().getEntityManagerFactory().callInTransaction(em -> {
                Member newMember = new Member(10, String.valueOf(10));
                em.persist((Object)newMember);
                return newMember;
            });
            Member foundMember = (Member)this.getEntityManager().find(Member.class, (Object)10);
            if (member.equals(foundMember)) {
                pass = true;
            } else {
                this.logErr("Stored entity data are not same as found");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("callInTransactionTest failed");
        }
    }

    public void runInTransactionTest() throws Exception {
        int MEMBER_ID = 11;
        boolean pass = false;
        try {
            this.getEntityManager().getEntityManagerFactory().runInTransaction(em -> {
                Member newMember = new Member(11, String.valueOf(11));
                em.persist((Object)newMember);
            });
            Member foundMember = (Member)this.getEntityManager().find(Member.class, (Object)11);
            if (foundMember != null) {
                pass = true;
            } else {
                this.logErr("Stored entity data was not found");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("runInTransactionTest failed");
        }
    }

    public void getNameTest() throws Exception {
        boolean pass = false;
        try {
            String puName = this.getEntityManager().getEntityManagerFactory().getName();
            if (this.getPersistenceUnitName().equals(puName)) {
                pass = true;
            } else {
                this.logErr("Persistence unit name |" + puName + "| doesn't match with expected |" + this.getPersistenceUnitName() + "|");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("getNameTest failed");
        }
    }
}

