/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.mappedsuperclasstype;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.mappedsuperclasstype.FullTimeEmployee;
import ee.jakarta.tck.persistence.core.metamodelapi.mappedsuperclasstype.FullTimeEmployee2;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.MappedSuperclassType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void mappedSuperclassType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            pass = false;
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            Set aSet = metaModel.getEntities();
            if (aSet != null) {
                this.logTrace("Obtained Non-null Set of EntityType");
                for (EntityType mType : aSet) {
                    this.logTrace("EntityType:" + mType.getJavaType().getName());
                    IdentifiableType idType = mType.getSupertype();
                    if (idType == null) continue;
                    this.logTrace("IdentifiableType:" + idType.getJavaType().getName());
                    if (!(idType instanceof MappedSuperclassType)) continue;
                    this.logTrace("type is instance of MappedSuperClassType:" + idType.getJavaType().getName());
                    pass = true;
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("mappedSuperclassType failed");
        }
    }

    public void getDeclaredId() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    SingularAttribute idAttrib = idType.getDeclaredId(String.class);
                    if (idAttrib != null) {
                        String name = idAttrib.getType().getJavaType().getName();
                        if (name.equals("java.lang.String")) {
                            this.logTrace("Received:" + name);
                            pass = true;
                        } else {
                            this.logErr("Expected java.lang.String, actual:" + name);
                        }
                    } else {
                        this.logErr("getDeclaredId(...) returned null");
                    }
                } else {
                    this.logErr("getSupertype() returned null");
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredId failed");
        }
    }

    public void getDeclaredIdIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        idType.getDeclaredId(Date.class);
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("getSupertype() returned null");
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredIdIllegalArgumentException failed");
        }
    }

    public void getDeclaredVersion() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    SingularAttribute idAttrib = idType.getDeclaredVersion(Integer.class);
                    if (idAttrib != null) {
                        String name = idAttrib.getType().getJavaType().getName();
                        if (name.equals("java.lang.Integer")) {
                            this.logTrace("Received:" + name);
                            pass = true;
                        } else {
                            this.logErr("Expected java.lang.Integer, actual:" + name);
                        }
                    } else {
                        this.logErr("getDeclaredId(...) returned null");
                    }
                } else {
                    this.logErr("getSupertype() returned null");
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredVersion failed");
        }
    }

    public void getDeclaredVersionIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        idType.getDeclaredVersion(Date.class);
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("getSupertype() returned null");
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getDeclaredVersionIllegalArgumentException failed");
        }
    }

    public void getId() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    SingularAttribute idAttrib = idType.getId(String.class);
                    if (idAttrib != null) {
                        String name = idAttrib.getType().getJavaType().getName();
                        if (name.equals("java.lang.String")) {
                            this.logTrace("Received:" + name);
                            pass = true;
                        } else {
                            this.logErr("Expected java.lang.String, actual:" + name);
                        }
                    } else {
                        this.logErr("getDeclaredId(...) returned null");
                    }
                } else {
                    this.logErr("getSupertype() returned null");
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getId failed");
        }
    }

    public void getIdIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        idType.getId(Date.class);
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("getSupertype() returned null");
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdIllegalArgumentException failed");
        }
    }

    public void getIdClassAttributes() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        Collections.sort(expected);
        ArrayList<String> actual = new ArrayList<String>();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    Set idAttribSet = idType.getIdClassAttributes();
                    if (idAttribSet != null) {
                        if (idAttribSet.size() > 0) {
                            for (Attribute attrib : idAttribSet) {
                                actual.add(attrib.getName());
                            }
                            Collections.sort(actual);
                            if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                                this.logTrace("Received expected attributes");
                                for (String attribName : expected) {
                                    this.logTrace("attrib:" + attribName);
                                }
                                pass = true;
                            } else {
                                this.logErr("Received Unexpected attributes");
                                this.logErr("Expected:");
                                for (String attribName : expected) {
                                    this.logErr("attrib:" + attribName);
                                }
                                this.logErr("Actual:");
                                for (String attribName : actual) {
                                    this.logErr("attrib:" + attribName);
                                }
                            }
                        } else {
                            this.logErr("getIdClassAttributes() returned 0 results");
                        }
                    } else {
                        this.logErr("getIdClassAttributes() returned null");
                    }
                } else {
                    this.logErr("getSupertype() returned null");
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdClassAttributes failed");
        }
    }

    public void getIdClassAttributesIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        idType.getIdClassAttributes();
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("getSupertype() returned null");
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getIdClassAttributesIllegalArgumentException failed");
        }
    }

    public void getIdType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    String name = idType.getIdType().getJavaType().getName();
                    if (name.equals("java.lang.String")) {
                        this.logTrace("Received expected: " + name);
                        pass = true;
                    } else {
                        this.logErr("Expected java.lang.String, actual:" + name);
                    }
                } else {
                    this.logErr("getSupertype() returned null");
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getId failed");
        }
    }

    public void getVersion() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    SingularAttribute idAttrib = eType.getVersion(Integer.class);
                    String name = idAttrib.getType().getJavaType().getName();
                    if (name.equals("java.lang.Integer")) {
                        pass = true;
                    } else {
                        this.logErr("Expected java.lang.Integer, actual:" + name);
                    }
                } else {
                    this.logErr("getSupertype() returned null");
                }
            } else {
                this.logErr("getEntity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getVersion failed");
        }
    }

    public void getVersionIllegalArgumentException() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    try {
                        eType.getVersion(Date.class);
                        this.logTrace("Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        this.logErr("Received unexpected exception", e);
                    }
                } else {
                    this.logErr("getSupertype() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getVersionIllegalArgumentException failed");
        }
    }

    public void hasSingleIdAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    boolean hasSingleIdAttribute = idType.hasSingleIdAttribute();
                    if (hasSingleIdAttribute) {
                        pass = true;
                        this.logTrace("hasSingleIdAttribute() returned" + hasSingleIdAttribute);
                    } else {
                        this.logErr("Expected: false, actual:" + hasSingleIdAttribute);
                    }
                } else {
                    this.logErr("getSupertype() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("hasSingleIdAttribute failed");
        }
    }

    public void hasVersionAttribute() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(FullTimeEmployee2.class);
            if (eType != null) {
                this.logTrace("Obtained Non-null EntityType");
                IdentifiableType idType = eType.getSupertype();
                if (idType != null) {
                    boolean hasVersionAttribute = idType.hasVersionAttribute();
                    if (hasVersionAttribute) {
                        pass = true;
                        this.logTrace("hasVersionAttribute() returned" + hasVersionAttribute);
                    } else {
                        this.logErr("Expected: false, actual:" + hasVersionAttribute);
                    }
                } else {
                    this.logErr("getSupertype() returned null");
                }
            } else {
                this.logErr("entity(...) returned null");
            }
        } else {
            this.logErr("getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("hasVersionAttribute failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

