/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.session.stateful.interceptor.method.annotated;

import com.sun.ts.tests.ejb30.common.calc.CalculatorException;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.interceptor.AroundInvokeBase;
import com.sun.ts.tests.ejb30.common.interceptor.AroundInvokeIF;
import com.sun.ts.tests.ejb30.common.interceptor.AroundInvokeTestImpl;
import com.sun.ts.tests.ejb30.common.interceptor.Constants;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBContext;
import jakarta.ejb.EJBException;
import jakarta.ejb.Remote;
import jakarta.ejb.Remove;
import jakarta.ejb.SessionContext;
import jakarta.ejb.SessionSynchronization;
import jakarta.ejb.Stateful;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.lang.reflect.Method;

@Stateful(name="AroundInvokeBean")
@Remote(value={AroundInvokeIF.class})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class AroundInvokeBean
extends AroundInvokeBase
implements AroundInvokeIF,
SessionSynchronization,
Constants,
Serializable {
    @Resource(name="ejbContext")
    private SessionContext ejbContext;
    private boolean afterCompletionCalled;
    private boolean beforeCompletionCalled;
    private boolean afterBeginCalled;

    @Override
    protected EJBContext getEJBContext() {
        return this.ejbContext;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        Object result = null;
        boolean orderInChain = true;
        Method meth = ctx.getMethod();
        String methName = meth.getName();
        TLogger.log("Creating AroundInvokeTestMDBImpl with: ejbContext=" + this.ejbContext + "; bean=" + this + ", callerPrincipal=" + this.ejbContext.getCallerPrincipal());
        AroundInvokeTestImpl helper = new AroundInvokeTestImpl(this, this.getEJBContext().getCallerPrincipal());
        if ("afterBeginTest".equals(methName)) {
            if (!this.isAfterBeginCalled()) {
                throw new CalculatorException("afterBegin() was not called before this interceptor.");
            }
            TLogger.log("good, isAfterBeginCalled: " + this.isAfterBeginCalled() + ", proceed...");
            return helper.intercept(ctx);
        }
        if (!"beforeCompletionTest".equals(methName)) {
            return helper.intercept(ctx);
        }
        if (!"beforeCompletionTest".equals(methName)) {
            throw new IllegalStateException("Only beforeCompletionTest can get here, but current method name is " + methName);
        }
        try {
            result = ctx.proceed();
        }
        catch (CalculatorException e) {
            try {
                throw e;
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new IllegalStateException(e3);
                }
            }
            catch (Throwable throwable) {
                if (this.isBeforeCompletionCalled()) {
                    throw new CalculatorException("beforeCompletion must not be called before any interceptor.");
                }
                TLogger.log("good, isBeforeCompletionCalled after proceed(): " + this.isBeforeCompletionCalled());
                throw throwable;
            }
        }
        if (this.isBeforeCompletionCalled()) {
            throw new CalculatorException("beforeCompletion must not be called before any interceptor.");
        }
        TLogger.log("good, isBeforeCompletionCalled after proceed(): " + this.isBeforeCompletionCalled());
        return result;
    }

    public void afterCompletion(boolean param) throws EJBException {
        this.setAfterCompletionCalled(true);
    }

    public void beforeCompletion() throws EJBException {
        this.setBeforeCompletionCalled(true);
    }

    public void afterBegin() throws EJBException {
        this.setAfterBeginCalled(true);
    }

    private boolean isAfterCompletionCalled() {
        return this.afterCompletionCalled;
    }

    private void setAfterCompletionCalled(boolean afterCompletionCalled) {
        this.afterCompletionCalled = afterCompletionCalled;
    }

    private boolean isBeforeCompletionCalled() {
        return this.beforeCompletionCalled;
    }

    private void setBeforeCompletionCalled(boolean beforeCompletionCalled) {
        this.beforeCompletionCalled = beforeCompletionCalled;
    }

    private boolean isAfterBeginCalled() {
        return this.afterBeginCalled;
    }

    private void setAfterBeginCalled(boolean afterBeginCalled) {
        this.afterBeginCalled = afterBeginCalled;
    }

    @Override
    @Remove
    public void remove() {
    }
}

