/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.bidironexone;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.bidironexone.BiDir1X1Person;
import ee.jakarta.tck.persistence.core.relationship.bidironexone.BiDir1X1Project;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void biDir1X1Test1() throws Exception {
        this.logTrace("Begin biDir1X1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BiDir1X1Project project = new BiDir1X1Project(1L, "JavaEE", 500.0f);
            BiDir1X1Person person = new BiDir1X1Person(1L, "Duke");
            project.setBiDir1X1Person(person);
            person.setProject(project);
            this.getEntityManager().persist((Object)project);
            this.getEntityTransaction().commit();
            this.logTrace("persisted Project this in turn must persist Person too..");
            this.getEntityTransaction().begin();
            BiDir1X1Person newPerson = (BiDir1X1Person)this.getEntityManager().find(BiDir1X1Person.class, (Object)1L);
            if (newPerson != null) {
                this.logTrace("Found Searched Person Entity");
                if (this.getEntityManager().contains((Object)newPerson) && newPerson.getName().equals("Duke")) {
                    this.logTrace("biDir1X1Test1: Expected results received");
                    pass = true;
                }
            } else {
                this.logTrace("searched Person not found");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("biDir1X1Test1 failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIR1X1PERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIR1X1PROJECT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

