/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.misc.metadataComplete.warejb;

import com.sun.ts.tests.ejb30.common.calc.RemoteCalculator;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBs;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import javax.naming.Context;
import javax.naming.NamingException;

@EJBs(value={@EJB(name="typeLevelBeanNotInjected", beanInterface=RemoteCalculator.class, beanName="StatelessRemoteCalculatorBean")})
public class TestServlet
extends HttpTCKServlet {
    @EJB(name="statelessBeanNotInjected", beanName="StatelessRemoteCalculatorBean")
    private RemoteCalculator statelessBeanNotInjected;
    @EJB(name="statefulBeanNotInjected", beanName="StatefulRemoteCalculatorBean")
    private RemoteCalculator statefulBeanNotInjected;
    @EJB(name="statelessBean", beanName="StatelessRemoteCalculatorBean")
    private RemoteCalculator statelessBean;
    @EJB(name="statefulBean", beanName="StatefulRemoteCalculatorBean")
    private RemoteCalculator statefulBean;
    private RemoteCalculator excludeDefaultIncludeClass;
    private RemoteCalculator excludeDefaultAndClassReinstateDefault;
    private RemoteCalculator sameInterceptor3Times;

    private void operation(RemoteCalculator bean, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        int op1 = 2;
        int op2 = 3;
        int expected = op1 + op2 + 100 + 100;
        int result = 0;
        try {
            result = bean.remoteAdd(op1, op2);
        }
        catch (Exception e) {
            pw.println("Test FAILED" + e);
        }
        if (result == expected) {
            pw.println("Test PASSEDGot expected result: " + result);
        } else {
            pw.println("Test FAILEDExpected " + expected + ", actual " + result);
        }
    }

    public void annotationNotProcessedForStateless(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.operation(this.statelessBean, request, response);
    }

    public void annotationNotProcessedForStateful(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.operation(this.statefulBean, request, response);
    }

    public void annotationNotProcessedForWar(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        if (this.statelessBeanNotInjected == null && this.statefulBeanNotInjected == null) {
            pw.println("Test PASSED.  Annotated fields are not injected, since this war has been marked as metadata-complete.");
        } else {
            pw.println("Test FAILED.  Annotated fields should not be injected, since this war has been marked as metadata-complete.  But these fields were injected: \n" + this.statelessBeanNotInjected + "\n" + this.statefulBeanNotInjected);
        }
    }

    public void typeLevelAnnotationNotProcessedForWar(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String lookupName = "java:comp/env/typeLevelBeanNotInjected";
        Object lookupValue = null;
        try {
            lookupValue = ServiceLocator.lookup(lookupName, new Context[0]);
            pw.println("Test FAILED" + lookupName + " must not be injected at the servlet type level, since a full war descriptor is used.  The value looked up is " + lookupValue);
        }
        catch (NamingException e) {
            pw.println("Test PASSEDGot expected javax.naming.NamingException when looking up " + lookupName);
        }
        lookupName = "java:comp/env/typeLevelOrbNotInjected";
        try {
            lookupValue = ServiceLocator.lookup(lookupName, new Context[0]);
            pw.println("Test FAILED" + lookupName + " must not be injected at the servlet type level, since a full war descriptor is used.  The value looked up is " + lookupValue);
        }
        catch (NamingException e) {
            pw.println("Test PASSEDGot expected javax.naming.NamingException when looking up " + lookupName);
        }
    }

    public void excludeDefaultIncludeClassInterceptor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        int param1 = 0;
        int param2 = 0;
        int additionByInterceptor = 200;
        int postConstructCallsCount = 1;
        int expected = param1 + param2 + additionByInterceptor + postConstructCallsCount;
        int actual = this.excludeDefaultIncludeClass.remoteAdd(param1, param2);
        if (actual == expected) {
            pw.println("Got expected result : " + actual);
        } else {
            pw.println("Test FAILED Expecting result: " + expected + ", but actual is " + actual);
        }
        actual = this.excludeDefaultIncludeClass.remoteSubtract(param1, param2);
        if (actual == expected) {
            pw.println("Test PASSED Got expected result : " + actual);
        } else {
            pw.println("Test FAILED Expecting result: " + expected + ", but actual is " + actual);
        }
    }

    public void excludeDefaulAndClassReinstateDefault(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        int param1 = 0;
        int param2 = 0;
        int additionByInterceptor = 200;
        int postConstructCallsCount = 1;
        int expected = param1 + param2 + additionByInterceptor + postConstructCallsCount;
        int actual = this.excludeDefaultAndClassReinstateDefault.remoteAdd(param1, param2);
        if (actual == expected) {
            pw.println("Test PASSED Got expected result : " + actual);
        } else {
            pw.println("Test FAILED Expecting result: " + expected + ", but actual is " + actual);
        }
    }

    public void defaultAndMethodInterceptor(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        int param1 = 0;
        int param2 = 0;
        int additionByInterceptor = 400;
        int postConstructCallsCount = 1;
        int expected = param1 + param2 + additionByInterceptor + postConstructCallsCount;
        int actual = this.excludeDefaultAndClassReinstateDefault.remoteSubtract(param1, param2);
        if (actual == expected) {
            pw.println("Test PASSED Got expected result : " + actual);
        } else {
            pw.println("Test FAILED Expecting result: " + expected + ", but actual is " + actual);
        }
    }

    public void sameInterceptor3Times(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        int param1 = 0;
        int param2 = 0;
        int additionByInterceptor = 600;
        int postConstructCallsCount = 1;
        int expected = param1 + param2 + additionByInterceptor + postConstructCallsCount;
        int actual = this.sameInterceptor3Times.remoteAdd(param1, param2);
        if (actual == expected) {
            pw.println("Test PASSED Got expected result : " + actual);
        } else {
            pw.println("Test FAILED Expecting result: " + expected + ", but actual is " + actual);
        }
    }

    public void sameInterceptorTwice(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        int param1 = 0;
        int param2 = 0;
        int additionByInterceptor = 400;
        int postConstructCallsCount = 1;
        int expected = param1 + param2 + additionByInterceptor + postConstructCallsCount;
        int actual = this.sameInterceptor3Times.remoteSubtract(param1, param2);
        if (actual == expected) {
            pw.println("Test PASSED Got expected result : " + actual);
        } else {
            pw.println("Test FAILED Expecting result: " + expected + ", but actual is " + actual);
        }
    }
}

