/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.integration.sec.secbasicssl;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.porting.TSHttpsURLConnection;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.BASE64Encoder;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.lib.util.WebUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;

public class Client
extends EETest {
    private String hostname = null;
    private int portnum = 0;
    private String pageBase = "/integration_sec_secbasicssl_web";
    private String basicSSLPage = "/basicSSL.jsp";
    private String webNoAuthzPage = "/webNoAuthz.jsp";
    private String webNotInRolePage = "/webNotInRole.jsp";
    private String webApiRemoteUser1Page = "/webApiRemoteUser1.jsp";
    private String authorizedPage = "/authorized.jsp";
    private String webRoleRefScope1Page = "/webRoleRefScope1.jsp";
    private String rolereversePage = "/rolereverse.jsp";
    private String requestAttributesPage = "/requestAttributes.jsp";
    private String user = null;
    private final String webHostProp = "webServerHost";
    private final String webPortProp = "webServerPort";
    private final String userProp = "user";
    private final String passString = "PASSED!";
    private final String failString = "FAILED!";
    private final int numTests = 9;
    private String request = null;
    private WebUtil.Response response = null;
    private TSURL ctsurl = new TSURL();
    private String username = "";
    private String password = "";
    private TSLoginContext lc = null;
    private TSHttpsURLConnection tsHttpsURLConn = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logMsg((String)"setup...");
        this.hostname = p.getProperty("webServerHost");
        this.username = p.getProperty("user");
        this.password = p.getProperty("password");
        this.user = p.getProperty("user");
        this.portnum = Integer.parseInt(p.getProperty("securedWebServicePort"));
        TestUtil.logMsg((String)("securedWebServicePort =" + p.getProperty("securedWebServicePort")));
    }

    public void test_login_basic_over_ssl() throws Exception {
        String testName = "test_login_basic_over_ssl";
        String url = this.ctsurl.getURLString("https", this.hostname, this.portnum, this.pageBase + this.basicSSLPage);
        try {
            String line;
            URL newURL = new URL(url);
            String authData = this.username + ":" + this.password;
            TestUtil.logMsg((String)("authData : " + authData));
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            TestUtil.logMsg((String)("encoded authData : " + encodedAuthData));
            TSHttpsURLConnection httpsURLConn = this.getHttpsURLConnection(newURL);
            httpsURLConn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            InputStream content = httpsURLConn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(content));
            Object output = "";
            while ((line = in.readLine()) != null) {
                output = (String)output + line;
                TestUtil.logMsg((String)line);
            }
            this.verifyTestOutput((String)output, testName);
            httpsURLConn.disconnect();
        }
        catch (Exception e) {
            throw new Exception(testName + ": FAILED", e);
        }
    }

    public void test_web_no_authz() throws Exception {
        String testName = "test_web_no_authz";
        String url = this.ctsurl.getURLString("https", this.hostname, this.portnum, this.pageBase + this.webNoAuthzPage);
        try {
            URL newURL = new URL(url);
            String output = this.invokeHttpsURL(newURL);
            this.verifyTestOutput(output, testName);
        }
        catch (Exception e) {
            throw new Exception(testName + ": FAILED", e);
        }
    }

    public void test_web_not_in_role() throws Exception {
        String testName = "test_web_not_in_role";
        String url = this.ctsurl.getURLString("https", this.hostname, this.portnum, this.pageBase + this.webNotInRolePage);
        try {
            URL newURL = new URL(url);
            String output = this.invokeHttpsURL(newURL);
            this.verifyTestOutput(output, testName);
        }
        catch (Exception e) {
            throw new Exception(testName + ": FAILED", e);
        }
    }

    public void test_web_api_remoteuser_1() throws Exception {
        String testName = "test_web_api_remoteuser_1";
        String url = this.ctsurl.getURLString("https", this.hostname, this.portnum, this.pageBase + this.webApiRemoteUser1Page);
        try {
            URL newURL = new URL(url);
            String output = this.invokeHttpsURL(newURL);
            this.verifyTestOutput(output, testName);
        }
        catch (Exception e) {
            throw new Exception(testName + ": FAILED", e);
        }
    }

    public void test_web_api_remoteuser_2() throws Exception {
        String testName = "test_web_api_remoteuser_2";
        String url = this.ctsurl.getURLString("https", this.hostname, this.portnum, this.pageBase + this.authorizedPage);
        try {
            String line;
            URL newURL = new URL(url);
            String authData = this.username + ":" + this.password;
            TestUtil.logMsg((String)("authData : " + authData));
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            TestUtil.logMsg((String)("encoded authData : " + encodedAuthData));
            TSHttpsURLConnection httpsURLConn = this.getHttpsURLConnection(newURL);
            httpsURLConn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            InputStream content = httpsURLConn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(content));
            Object output = "";
            while ((line = in.readLine()) != null) {
                output = (String)output + line;
                TestUtil.logMsg((String)line);
            }
            String userNameToSearch = this.username;
            if (((String)output).indexOf(userNameToSearch) == -1) {
                throw new Exception(testName + ": getRemoteUser(): - did not find \"" + userNameToSearch + "\" in log.");
            }
            TestUtil.logMsg((String)"Additional verification done");
            this.verifyTestOutput((String)output, testName);
            httpsURLConn.disconnect();
        }
        catch (Exception e) {
            throw new Exception(testName + ": FAILED", e);
        }
    }

    public void test_web_roleref_scope_1() throws Exception {
        String testName = "test_web_roleref_scope_1";
        String url = this.ctsurl.getURLString("https", this.hostname, this.portnum, this.pageBase + this.webRoleRefScope1Page);
        try {
            String line;
            URL newURL = new URL(url);
            String authData = this.username + ":" + this.password;
            TestUtil.logMsg((String)("authData : " + authData));
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            TestUtil.logMsg((String)("encoded authData : " + encodedAuthData));
            TSHttpsURLConnection httpsURLConn = this.getHttpsURLConnection(newURL);
            httpsURLConn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            InputStream content = httpsURLConn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(content));
            Object output = "";
            while ((line = in.readLine()) != null) {
                output = (String)output + line;
                TestUtil.logMsg((String)line);
            }
            this.verifyTestOutput((String)output, testName);
            httpsURLConn.disconnect();
        }
        catch (Exception e) {
            throw new Exception(testName + ": FAILED", e);
        }
    }

    public void test_web_roleref_scope_2() throws Exception {
        String testName = "test_web_roleref_scope_2";
        String url = this.ctsurl.getURLString("https", this.hostname, this.portnum, this.pageBase + this.rolereversePage);
        try {
            String line;
            URL newURL = new URL(url);
            String authData = this.username + ":" + this.password;
            TestUtil.logMsg((String)("authData : " + authData));
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            TestUtil.logMsg((String)("encoded authData : " + encodedAuthData));
            TSHttpsURLConnection httpsURLConn = this.getHttpsURLConnection(newURL);
            httpsURLConn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            InputStream content = httpsURLConn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(content));
            Object output = "";
            while ((line = in.readLine()) != null) {
                output = (String)output + line;
                TestUtil.logMsg((String)line);
            }
            this.verifyTestOutput((String)output, testName);
            httpsURLConn.disconnect();
        }
        catch (Exception e) {
            throw new Exception(testName + ": FAILED", e);
        }
    }

    public void test_web_is_authz() throws Exception {
        String testName = "test_web_is_authz";
        String url = this.ctsurl.getURLString("https", this.hostname, this.portnum, this.pageBase + this.authorizedPage);
        try {
            String line;
            URL newURL = new URL(url);
            String authData = this.username + ":" + this.password;
            TestUtil.logMsg((String)("authData : " + authData));
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            TestUtil.logMsg((String)("encoded authData : " + encodedAuthData));
            TSHttpsURLConnection httpsURLConn = this.getHttpsURLConnection(newURL);
            httpsURLConn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            InputStream content = httpsURLConn.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(content));
            Object output = "";
            while ((line = in.readLine()) != null) {
                output = (String)output + line;
                TestUtil.logMsg((String)line);
            }
            String stringToSearch = "PASSED";
            if (((String)output).indexOf(stringToSearch) == -1) {
                throw new Exception(testName + ": getRemoteUser(): - did not find \"" + stringToSearch + "\" in log.");
            }
            TestUtil.logMsg((String)"Additional verification done");
            httpsURLConn.disconnect();
        }
        catch (Exception e) {
            throw new Exception(testName + ": FAILED", e);
        }
    }

    public void test_request_attributes() throws Exception {
        String testName = "test_request_attributes";
        String url = this.ctsurl.getURLString("https", this.hostname, this.portnum, this.pageBase + this.requestAttributesPage);
        try {
            URL newURL = new URL(url);
            String output = this.invokeHttpsURL(newURL);
            this.verifyTestOutput(output, testName);
        }
        catch (Exception e) {
            throw new Exception(testName + ": FAILED", e);
        }
    }

    public void cleanup() throws Exception {
        TestUtil.logMsg((String)"cleanup...");
    }

    public TSHttpsURLConnection getHttpsURLConnection(URL newURL) throws IOException {
        TSHttpsURLConnection httpsURLConn = null;
        httpsURLConn = new TSHttpsURLConnection();
        if (httpsURLConn == null) {
            throw new IOException("Error opening httsURLConnection");
        }
        TestUtil.logMsg((String)("Opening https url connection to: " + newURL.toString()));
        httpsURLConn.init(newURL);
        httpsURLConn.setDoInput(true);
        httpsURLConn.setDoOutput(true);
        httpsURLConn.setUseCaches(false);
        return httpsURLConn;
    }

    public void verifyTestOutput(String output, String testName) throws Exception {
        if (output.indexOf(testName + ": PASSED") == -1) {
            TestUtil.logMsg((String)("Expected String from the output = " + testName + ": PASSED"));
            TestUtil.logMsg((String)("received output = " + output));
            throw new Exception(testName + ": FAILED");
        }
    }

    public String addCookies(String cookieHeader, String cookies) {
        String cookie;
        if (cookieHeader == null) {
            return null;
        }
        int j = cookieHeader.indexOf(";");
        if (j != -1) {
            String cValue = cookieHeader.substring(0, j);
            cookie = cValue.trim();
        } else {
            cookie = cookieHeader.trim();
        }
        cookies = cookies == null ? cookie : (String)cookies + ";" + cookie;
        return cookies;
    }

    public String invokeHttpsURL(URL newURL) throws IOException {
        TSHttpsURLConnection httpsURLConn = this.getHttpsURLConnection(newURL);
        InputStream content = httpsURLConn.getInputStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(content));
        Object output = "";
        String line = "";
        while ((line = in.readLine()) != null) {
            output = (String)output + line;
            TestUtil.logMsg((String)line);
        }
        TestUtil.logMsg((String)("Output :" + (String)output));
        httpsURLConn.disconnect();
        return output;
    }
}

