/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.util.sec.reflect.annotation;

import com.sun.ts.lib.util.sec.misc.SharedSecrets;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class AnnotationType {
    private final Map<String, Class> memberTypes = new HashMap<String, Class>();
    private final Map<String, Object> memberDefaults = new HashMap<String, Object>();
    private final Map<String, Method> members = new HashMap<String, Method>();
    private RetentionPolicy retention = RetentionPolicy.RUNTIME;
    private boolean inherited = false;

    public static synchronized AnnotationType getInstance(Class annotationClass) {
        AnnotationType result = SharedSecrets.getJavaLangAccess().getAnnotationType(annotationClass);
        if (result == null) {
            result = new AnnotationType(annotationClass);
        }
        return result;
    }

    private AnnotationType(Class<?> annotationClass) {
        Method[] methods;
        if (!annotationClass.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type");
        }
        for (Method method : methods = annotationClass.getDeclaredMethods()) {
            if (method.getParameterTypes().length != 0) {
                throw new IllegalArgumentException(String.valueOf(method) + " has params");
            }
            String name = method.getName();
            Class<?> type = method.getReturnType();
            this.memberTypes.put(name, AnnotationType.invocationHandlerReturnType(type));
            this.members.put(name, method);
            Object defaultValue = method.getDefaultValue();
            if (defaultValue != null) {
                this.memberDefaults.put(name, defaultValue);
            }
            this.members.put(name, method);
        }
        SharedSecrets.getJavaLangAccess().setAnnotationType(annotationClass, this);
        if (annotationClass != Retention.class && annotationClass != Inherited.class) {
            Retention ret = annotationClass.getAnnotation(Retention.class);
            this.retention = ret == null ? RetentionPolicy.CLASS : ret.value();
            this.inherited = annotationClass.isAnnotationPresent(Inherited.class);
        }
    }

    public static Class invocationHandlerReturnType(Class type) {
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        return type;
    }

    public Map<String, Class> memberTypes() {
        return this.memberTypes;
    }

    public Map<String, Method> members() {
        return this.members;
    }

    public Map<String, Object> memberDefaults() {
        return this.memberDefaults;
    }

    public RetentionPolicy retention() {
        return this.retention;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("Annotation Type:\n");
        s.append("   Member types: " + String.valueOf(this.memberTypes) + "\n");
        s.append("   Member defaults: " + String.valueOf(this.memberDefaults) + "\n");
        s.append("   Retention policy: " + String.valueOf((Object)this.retention) + "\n");
        s.append("   Inherited: " + this.inherited);
        return s.toString();
    }
}

