/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.sec.stateless.lsecr;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.sec.stateless.common.SecTestLocal;
import com.sun.ts.tests.ejb30.sec.stateless.common.SecTestRoleRefLocal;
import com.sun.ts.tests.ejb30.sec.stateless.common.lTest;
import jakarta.annotation.Resource;
import jakarta.annotation.security.RolesAllowed;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBException;
import jakarta.ejb.EJBs;
import jakarta.ejb.Remote;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import java.util.Properties;

@Stateless(name="lTestEJB")
@Remote(value={lTest.class})
@EJBs(value={@EJB(name="SecTestEJB", beanName="SecTestEJB", beanInterface=SecTestLocal.class), @EJB(name="SecTestRoleRefEJB", beanName="SecTestRoleRefEJB", beanInterface=SecTestRoleRefLocal.class)})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@RunAs(value="Manager")
public class lTestEJB
implements lTest {
    @EJB(beanName="SecTestEJB")
    private SecTestLocal ejb1 = null;
    @EJB(beanName="SecTestRoleRefEJB")
    private SecTestRoleRefLocal ejb2 = null;
    private SessionContext sctx = null;
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private String username = "";
    private String password = "";

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void initLogging(Properties p) {
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"TestEJB initLogging failed.");
            throw new EJBException(e.getMessage());
        }
    }

    @Resource
    public void setSessionContext(SessionContext sc) {
        this.sctx = sc;
        try {
            TestUtil.logMsg((String)"setSessionContext in TestEJB");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception in Setup: ", (Throwable)e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean IsCallerB1(String caller) {
        String name = this.sctx.getCallerPrincipal().getName();
        TestUtil.logMsg((String)("IsCallerB1: " + name));
        return name.indexOf(caller) >= 0;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean IsCallerB2(String caller, Properties p) {
        try {
            this.ejb1.initLogging(p);
            boolean result = this.ejb1.IsCaller(caller);
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean InRole(String role, Properties p) {
        try {
            this.ejb1.initLogging(p);
            boolean result = this.ejb1.EjbSecRoleRef(role);
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean EjbNotAuthz(Properties p) {
        try {
            this.ejb1.initLogging(p);
            this.ejb1.EjbNotAuthz();
            TestUtil.logErr((String)"Method call did not generate an expected java.rmi.RemoteException");
            return false;
        }
        catch (EJBException e) {
            TestUtil.logMsg((String)"Caught jakarta.ejb.EJBException as expected");
            this.cleanup(this.ejb1);
            return true;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.cleanup(this.ejb1);
            return false;
        }
    }

    private void cleanup(SecTestLocal ejbref) {
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean EjbIsAuthz(Properties p) {
        TestUtil.logMsg((String)"Starting Caller authorization test");
        try {
            this.ejb1.initLogging(p);
            boolean result = this.ejb1.EjbIsAuthz();
            if (!result) {
                return false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean EjbSecRoleRef(String role, Properties p) {
        TestUtil.logMsg((String)"Starting Security role reference positive test");
        try {
            this.ejb1.initLogging(p);
            boolean result = this.ejb1.EjbSecRoleRef(role);
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean EjbSecRoleRef1(String role, Properties p) {
        TestUtil.logMsg((String)"Starting Security role reference negative test");
        try {
            this.ejb1.initLogging(p);
            boolean result = this.ejb1.EjbSecRoleRef(role);
            return !result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean EjbSecRoleRefScope(String role, Properties p) {
        try {
            this.ejb1.initLogging(p);
            boolean result = this.ejb1.EjbSecRoleRef(role);
            if (!result) {
                return false;
            }
            this.ejb2.initLogging(p);
            result = this.ejb2.EjbSecRoleRefScope(role);
            return !result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean EjbOverloadedSecRoleRefs(String role1, String role2, Properties p) {
        TestUtil.logMsg((String)"Starting Overloaded security role references test");
        try {
            this.ejb1.initLogging(p);
            boolean result = this.ejb1.EjbOverloadedSecRoleRefs(role1);
            if (!result) {
                TestUtil.logErr((String)"EjbOverloadedSecRoleRefs(emp_secrole_ref) returned false");
                return false;
            }
            this.ejb1.initLogging(p);
            result = this.ejb1.EjbOverloadedSecRoleRefs(role1, role2);
            if (result) {
                TestUtil.logErr((String)"EjbOverloadedSecRoleRefs(emp_secrole_ref,mgr_secrole_ref) returned true");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("EjbOverloadedSecRoleRefs(" + role1 + "," + role2 + ") failed with Exception: "), (Throwable)e);
            return false;
        }
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean checktest1(Properties p) {
        try {
            this.ejb1.initLogging(p);
            boolean result = this.ejb1.checktest1();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean excludetest1(Properties p) {
        try {
            boolean result = this.ejb1.excludetest1();
            TestUtil.logTrace((String)"Should not be here.");
            return false;
        }
        catch (EJBException e) {
            TestUtil.logTrace((String)"Got expected EJBException");
            return true;
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Got wrong Exception in excludetest1:", (Throwable)ex);
            return false;
        }
    }
}

