/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.platform.ejbstateless;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;
import com.sun.ts.tests.jaxrs.platform.ejbstateless.StatelessLocalIF;
import com.sun.ts.tests.jaxrs.platform.ejbstateless.StatelessResource;
import com.sun.ts.tests.jaxrs.platform.ejbstateless.StatelessRootResource;
import com.sun.ts.tests.jaxrs.platform.ejbstateless.StatelessTestBean;
import com.sun.ts.tests.jaxrs.platform.ejbstateless.TSAppConfig;
import com.sun.ts.tests.jaxrs.platform.ejbstateless.TestFailedException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jaxrs"), @Tag(value="platform"), @Tag(value="web")})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -96529594720799580L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_platform_ejbstateless_web/ssb");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("com/sun/ts/tests/jaxrs/platform/ejbstateless/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_platform_ejbstateless_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, StatelessLocalIF.class, StatelessResource.class, StatelessRootResource.class, StatelessTestBean.class, TestFailedException.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void test1() throws Exception {
        this.setProperty("REQUEST", this.buildRequest(JAXRSCommonClient.Request.GET, ""));
        this.setProperty("SEARCH_STRING", "jaxrs_platform_ejbstateless_web|ssb");
        this.setProperty("SEARCH_STRING", "Hello|From|Stateless|EJB|Root");
        this.invoke();
    }

    @Test
    public void test2() throws Exception {
        this.setProperty("REQUEST", this.buildRequest(JAXRSCommonClient.Request.GET, "sub"));
        this.setProperty("SEARCH_STRING", "jaxrs_platform_ejbstateless_web|ssb");
        this.setProperty("SEARCH_STRING", "Hello|From|Stateless|EJB|Sub");
        this.invoke();
    }

    @Test
    public void test3() throws Exception {
        this.setProperty("REQUEST", this.buildRequest(JAXRSCommonClient.Request.GET, "localsub"));
        this.setProperty("SEARCH_STRING", "jaxrs_platform_ejbstateless_web|ssb");
        this.setProperty("SEARCH_STRING", "localsub|Hello|From|Stateless|Local|EJB|Sub");
        this.invoke();
    }

    @Test
    public void ejbExceptionTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "exception"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.CREATED));
        this.invoke();
    }

    @Test
    public void jaxrsInjectPriorPostConstructOnRootResourceTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "priorroot"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.valueOf(true));
        this.invoke();
    }
}

