/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.webclient;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.webclient.TestFailureException;
import com.sun.ts.tests.common.webclient.WebTestCase;
import com.sun.ts.tests.common.webclient.http.HttpRequest;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpState;

public abstract class BaseUrlClient
extends EETest {
    private static final Logger LOGGER = Logger.getLogger(BaseUrlClient.class.getName());
    public Properties _props;
    protected static final String UNAUTHORIZED = "401";
    protected static final String FORBIDDEN = "403";
    protected static final String NOT_FOUND = "404";
    protected static final String OK = "200";
    protected static final String CREATED = "201";
    protected static final String INTERNAL_SERVER_ERROR = "500";
    protected static final String SERVICE_UNAVAILABLE = "503";
    protected static final String CONTINUE = "100";
    protected static final String MOVED_TEMPORARY = "302";
    protected static final String GONE = "410";
    protected static final String LENGTH_REQUIRED = "411";
    protected static final String SERVLETHOSTPROP = "webServerHost";
    protected static final String SERVLETPORTPROP = "webServerPort";
    protected static final String TSHOME = "ts_home";
    protected static final Properties TEST_PROPS = new Properties();
    protected static final String STATUS_CODE = "status-code";
    protected static final String REASON_PHRASE = "reason-phrase";
    protected static final String EXPECTED_HEADERS = "expected_headers";
    protected static final String UNEXPECTED_HEADERS = "unexpected_headers";
    protected static final String EXPECT_RESPONSE_BODY = "expect_response_body";
    protected static final String REQUEST = "request";
    protected static final String REQUEST_HEADERS = "request_headers";
    protected static final String GOLDENFILE = "goldenfile";
    protected static final String SEARCH_STRING = "search_string";
    protected static final String SEARCH_STRING_IGNORE_CASE = "search_string_ignore_case";
    protected static final String BASIC_AUTH_USER = "basic_auth_user";
    protected static final String BASIC_AUTH_PASSWD = "basic_auth_passwd";
    protected static final String BASIC_AUTH_REALM = "basic_auth_realm";
    protected static final String UNORDERED_SEARCH_STRING = "unordered_search_string";
    protected static final String CONTENT = "content";
    protected static final String TEST_NAME = "testname";
    protected static final String RESPONSE_MATCH = "response_match";
    protected static final String UNEXPECTED_RESPONSE_MATCH = "unexpected_response_match";
    protected static final String STANDARD = "standard";
    protected static final String IGNORE_BODY = "ignore_body";
    protected static final String STRATEGY = "strategy";
    protected String TESTDIR = null;
    protected String GOLDENFILEDIR = "/src/web";
    protected static final String GET = "GET ";
    protected static final String HTTP10 = " HTTP/1.0";
    protected static final String HTTP11 = " HTTP/1.1";
    protected static final String SL = "/";
    protected static final String GF_SUFFIX = ".gf";
    protected static final String JSP_SUFFIX = ".jsp";
    protected static final String USE_SAVED_STATE = "use_saved_state";
    protected static final String SAVE_STATE = "save_state";
    protected static final String IGNORE_STATUS_CODE = "ignore_status_code";
    protected String _testName = null;
    protected String _tsHome = null;
    protected String _contextRoot = null;
    protected String _generalURI = null;
    protected String _hostname = null;
    protected int _port = 0;
    protected HttpState _state = null;
    protected WebTestCase _testCase = null;
    protected boolean _useSavedState = false;
    protected boolean _saveState = false;
    protected String FOLLOW_REDIRECT = "follow_redirect";
    protected boolean _redirect = false;

    public void setTestDir(String testDir) {
        this.TESTDIR = testDir;
    }

    public void setGeneralURI(String URI2) {
        this._generalURI = URI2;
    }

    public void setContextRoot(String root) {
        this._contextRoot = root;
    }

    public String getContextRoot() {
        return this._contextRoot;
    }

    public void setGoldenFileDir(String goldenDir) {
        this.GOLDENFILEDIR = goldenDir;
    }

    public void setup(String[] args, Properties p) throws Exception {
        this._props = p;
        String hostname = TestUtil.getProperty(p, SERVLETHOSTPROP).trim();
        String portnum = TestUtil.getProperty(p, SERVLETPORTPROP).trim();
        String tshome = TestUtil.getProperty(p, TSHOME).trim();
        if (this.isNullOrEmpty(hostname)) {
            throw new Exception("[BaseUrlClient] 'webServerHost' was not set in the ts.jte.");
        }
        this._hostname = hostname;
        if (this.isNullOrEmpty(portnum)) {
            throw new Exception("[BaseUrlClient] 'webServerPort' was not set in the ts.jte.");
        }
        this._port = Integer.parseInt(portnum);
        if (this.isNullOrEmpty(tshome)) {
            throw new Exception("[BaseUrlClient] 'tshome' was not set in the  ts.jte.");
        }
        this._tsHome = tshome;
        TestUtil.logMsg("[BaseUrlClient] Test setup OK");
    }

    public void cleanup() throws Exception {
        TestUtil.logMsg("[BaseUrlClient] Test cleanup OK");
    }

    protected void invoke() throws Exception {
        try {
            this._testCase = new WebTestCase();
            this.setTestProperties(this._testCase);
            TestUtil.logTrace("[BaseUrlClient] EXECUTING");
            LOGGER.fine("[BaseUrlClient] EXECUTING");
            if (this._useSavedState && this._state != null) {
                this._testCase.getRequest().setState(this._state);
            }
            if (this._redirect) {
                TestUtil.logTrace("##########Call setFollowRedirects");
                LOGGER.fine("##########Call setFollowRedirects");
                this._testCase.getRequest().setFollowRedirects(this._redirect);
            }
            this._testCase.execute();
            TestUtil.logMsg(this._testCase.getResponse().getResponseBodyAsString());
            if (this._saveState) {
                this._state = this._testCase.getResponse().getState();
            }
        }
        catch (TestFailureException tfe) {
            Throwable t = tfe.getRootCause();
            if (t != null) {
                TestUtil.logErr("Root cause of Failure: " + t.getMessage(), t);
                LOGGER.log(Level.WARNING, "Root cause of Failure: " + t.getMessage(), t);
            }
            throw new Exception("[BaseUrlClient] " + this._testName + " failed!  Check output for cause of failure.", tfe);
        }
        finally {
            this._useSavedState = false;
            this._saveState = false;
            this._redirect = false;
            this.clearTestProperties();
        }
    }

    protected void setTestProperties(WebTestCase testCase) {
        HttpRequest req = testCase.getRequest();
        if (req == null) {
            String request = TEST_PROPS.getProperty(REQUEST);
            if (request.startsWith("GET") || request.startsWith("POST") || request.startsWith("OPTIONS") || request.startsWith("PUT") || request.startsWith("DELETE") || request.startsWith("HEAD") || request.endsWith(HTTP10) || request.endsWith(HTTP11)) {
                req = new HttpRequest(request, this._hostname, this._port);
                testCase.setRequest(req);
            } else {
                req = new HttpRequest(this.getTSRequest(request), this._hostname, this._port);
                testCase.setRequest(req);
            }
        }
        String key = null;
        String value = null;
        Enumeration<?> e = TEST_PROPS.propertyNames();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            value = TEST_PROPS.getProperty(key);
            if (key.equals(STATUS_CODE)) {
                testCase.setExpectedStatusCode(value);
                continue;
            }
            if (key.equals(IGNORE_STATUS_CODE)) {
                testCase.setExpectedStatusCode("-1");
                continue;
            }
            if (key.equals(REASON_PHRASE)) {
                testCase.setExpectedReasonPhrase(value);
                continue;
            }
            if (key.equals(EXPECTED_HEADERS)) {
                testCase.addExpectedHeader(value);
                continue;
            }
            if (key.equals(UNEXPECTED_HEADERS)) {
                testCase.addUnexpectedHeader(value);
                continue;
            }
            if (key.equals(SEARCH_STRING)) {
                testCase.setResponseSearchString(value);
                continue;
            }
            if (key.equals(SEARCH_STRING_IGNORE_CASE)) {
                testCase.setResponseSearchStringIgnoreCase(value);
                continue;
            }
            if (key.equals(STRATEGY)) {
                testCase.setStrategy(value);
                continue;
            }
            if (key.equals(GOLDENFILE)) {
                StringBuffer sb = new StringBuffer(50);
                sb.append(this._tsHome).append(this.GOLDENFILEDIR);
                sb.append(this._generalURI).append(SL);
                sb.append(value);
                testCase.setGoldenFilePath(sb.toString());
                continue;
            }
            if (key.equals(CONTENT)) {
                req.setContent(value);
                continue;
            }
            if (key.equals(TEST_NAME) || key.equals(RESPONSE_MATCH)) continue;
            if (key.equals(REQUEST_HEADERS)) {
                req.addRequestHeader(TEST_PROPS.getProperty(key));
                continue;
            }
            if (key.equals(EXPECT_RESPONSE_BODY)) continue;
            if (key.equals(IGNORE_BODY)) {
                testCase.setGoldenFilePath(null);
                continue;
            }
            if (key.equals(UNEXPECTED_RESPONSE_MATCH)) {
                testCase.setUnexpectedResponseSearchString(value);
                continue;
            }
            if (key.equals(UNORDERED_SEARCH_STRING)) {
                testCase.setUnorderedSearchString(value);
                continue;
            }
            if (key.equals(USE_SAVED_STATE)) {
                this._useSavedState = true;
                continue;
            }
            if (key.equals(SAVE_STATE)) {
                this._saveState = true;
                continue;
            }
            if (key.equals(this.FOLLOW_REDIRECT)) {
                LOGGER.fine("##########Found redirect Property");
                this._redirect = true;
                continue;
            }
            if (!key.equals(BASIC_AUTH_USER) && !key.equals(BASIC_AUTH_PASSWD) && !key.equals(BASIC_AUTH_REALM)) continue;
            String user = TEST_PROPS.getProperty(BASIC_AUTH_USER);
            String password = TEST_PROPS.getProperty(BASIC_AUTH_PASSWD);
            String realm = TEST_PROPS.getProperty(BASIC_AUTH_REALM);
            req.setAuthenticationCredentials(user, password, 1, realm);
        }
    }

    private String getTSRequest(String request) {
        StringBuffer finReq = new StringBuffer(50);
        finReq.append(GET).append(this._contextRoot).append(SL).append(this._generalURI);
        finReq.append(SL).append(request).append(HTTP10);
        return finReq.toString();
    }

    private void clearTestProperties() {
        TEST_PROPS.clear();
    }

    private boolean isNullOrEmpty(String val) {
        return val == null || val.equals("");
    }
}

