/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.resourceDefs.servlet;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.resource.ConnectionFactoryDefinition;
import jakarta.resource.ConnectionFactoryDefinitions;
import jakarta.resource.spi.TransactionSupport;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.HttpMethodConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

@DeclareRoles(value={"Administrator", "Manager", "Employee"})
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"Administrator"}), httpMethodConstraints={@HttpMethodConstraint(value="GET", rolesAllowed={"Administrator"}), @HttpMethodConstraint(value="POST", rolesAllowed={"Administrator"})})
@WebServlet(name="CRDTestServlet", urlPatterns={"/CRDTestServlet"})
@ConnectionFactoryDefinitions(value={@ConnectionFactoryDefinition(name="java:app/env/CRDTestServlet_App_ConnectorResource", description="application scoped connector resource definition", interfaceName="com.sun.ts.tests.common.connector.whitebox.TSConnectionFactory", resourceAdapter="whitebox-tx", transactionSupport=TransactionSupport.TransactionSupportLevel.NoTransaction), @ConnectionFactoryDefinition(name="java:comp/env/CRDTestServlet_Comp_ConnectorResource", description="component scoped connector resource definition", interfaceName="com.sun.ts.tests.common.connector.whitebox.TSConnectionFactory", resourceAdapter="whitebox-tx", transactionSupport=TransactionSupport.TransactionSupportLevel.LocalTransaction), @ConnectionFactoryDefinition(name="java:module/env/CRDTestServlet_Module_ConnectorResource", description="module scoped connector resource definition", interfaceName="com.sun.ts.tests.common.connector.whitebox.TSConnectionFactory", resourceAdapter="whitebox-tx", transactionSupport=TransactionSupport.TransactionSupportLevel.NoTransaction), @ConnectionFactoryDefinition(name="java:global/env/CRDTestServlet_Global_ConnectorResource", description="globally scoped connector resource definition", interfaceName="com.sun.ts.tests.common.connector.whitebox.TSConnectionFactory", resourceAdapter="whitebox-xa", transactionSupport=TransactionSupport.TransactionSupportLevel.XATransaction)})
public class CRDTestServlet
extends HttpServlet {
    private String servletAppContext = null;
    private String testMethod = null;
    private String RARJndiScope = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.debug("in CRDTestServlet.doGet()");
        this.getPropsAndParams(request, response);
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.debug("in CRDTestServlet.doPost()");
        this.getPropsAndParams(request, response);
        this.doTests(request, response);
    }

    private void doTests(HttpServletRequest request, HttpServletResponse response) {
        this.debug("in CRDTestServlet.doTests()");
        PrintWriter out = null;
        try {
            out = response.getWriter();
        }
        catch (Exception ex) {
            this.debug("got exception in CRDTestServlet");
            ex.printStackTrace();
        }
        this.getPropsAndParams(request, response);
        if (this.testMethod.equals("ValidateGlobalResourceDef")) {
            this.debug("CRDTestServlet.doTests(): testMethod == ValidateGlobalResourceDef");
            this.validateGlobalResourceDef(request, response);
        } else if (this.testMethod.equals("ValidateAppResourceDef")) {
            this.debug("CRDTestServlet.doTests(): testMethod == ValidateAppResourceDef");
            this.validateAppResourceDef(request, response);
        } else if (this.testMethod.equals("ValidateCompResourceDef")) {
            this.debug("CRDTestServlet.doTests(): testMethod == ValidateCompResourceDef");
            this.validateCompResourceDef(request, response);
        } else if (this.testMethod.equals("ValidateModuleResourceDef")) {
            this.debug("CRDTestServlet.doTests(): testMethod == ValidateModuleResourceDef");
            this.validateModuleResourceDef(request, response);
        }
    }

    private void getPropsAndParams(HttpServletRequest req, HttpServletResponse response) {
        this.testMethod = req.getParameter("method.under.test");
        this.RARJndiScope = req.getParameter("rar.jndi.scope");
        this.debug("CRDTestServlet.getPropsAndParams():  testMethod = " + this.testMethod);
        this.debug("CRDTestServlet.getPropsAndParams():  RARJndiScope = " + this.RARJndiScope);
    }

    public void validateGlobalResourceDef(HttpServletRequest request, HttpServletResponse response) {
        try {
            String jndiName = this.RARJndiScope;
            PrintWriter out = response.getWriter();
            this.debug("checking jndiName = " + jndiName);
            if (this.validateConnectorResource(jndiName, true)) {
                this.send_output(out, "CRDTestServlet->ValidateGlobalResourceDef() passed for jndiName=" + jndiName);
            } else {
                this.send_output(out, "validateConnectorResource() failed for jndiName: " + jndiName);
            }
        }
        catch (Exception ex) {
            System.out.println("CRDTestServlet->ValidateGlobalResourceDef() failed");
            ex.printStackTrace();
        }
    }

    public void validateAppResourceDef(HttpServletRequest request, HttpServletResponse response) {
        try {
            String jndiName = this.RARJndiScope;
            PrintWriter out = response.getWriter();
            this.debug("checking jndiName = " + jndiName);
            if (this.validateConnectorResource(jndiName, true)) {
                this.send_output(out, "CRDTestServlet->ValidateAppResourceDef() passed for jndiName=" + jndiName);
            } else {
                this.send_output(out, "validateAppResourceDef() failed for jndiName: " + jndiName);
            }
        }
        catch (Exception ex) {
            System.out.println("CRDTestServlet->ValidateAppResourceDef() failed");
            ex.printStackTrace();
        }
    }

    public void validateCompResourceDef(HttpServletRequest request, HttpServletResponse response) {
        try {
            String jndiName = this.RARJndiScope;
            PrintWriter out = response.getWriter();
            this.debug("checking jndiName = " + jndiName);
            if (this.validateConnectorResource(jndiName, true)) {
                this.send_output(out, "CRDTestServlet->ValidateCompResourceDef() passed for jndiName=" + jndiName);
            } else {
                this.send_output(out, "validateCompResourceDef() failed for jndiName: " + jndiName);
            }
        }
        catch (Exception ex) {
            System.out.println("CRDTestServlet->ValidateCompResourceDef() failed");
            ex.printStackTrace();
        }
    }

    public void validateModuleResourceDef(HttpServletRequest request, HttpServletResponse response) {
        try {
            String jndiName = this.RARJndiScope;
            PrintWriter out = response.getWriter();
            this.debug("checking jndiName = " + jndiName);
            if (this.validateConnectorResource(jndiName, true)) {
                this.send_output(out, "CRDTestServlet->ValidateModuleResourceDef() passed for jndiName=" + jndiName);
            } else {
                this.send_output(out, "validateModuleResourceDef() failed for jndiName: " + jndiName);
            }
        }
        catch (Exception ex) {
            System.out.println("CRDTestServlet->ValidateModuleResourceDef() failed");
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateConnectorResource(String jndiName, boolean expectSuccess) {
        Object c = null;
        boolean rval = false;
        try {
            this.debug("validateConnectorResource():  calling new TSNamingContext()");
            TSNamingContext ic = new TSNamingContext();
            this.debug("Doing lookup of jndiName = " + jndiName);
            TSDataSource ds = (TSDataSource)ic.lookup(jndiName);
            this.debug("validateConnectorResource(): Successfully did lookup of jndiName = " + jndiName);
            rval = true;
        }
        catch (Exception e) {
            this.debug("Fail to access connector resource: " + jndiName);
            e.printStackTrace();
        }
        finally {
            this.debug("finally:  Fail to access connector resource: " + jndiName);
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception exception) {}
        }
        return rval;
    }

    public void send_output(PrintWriter out, String str) {
        if (out != null) {
            out.println(str);
            out.flush();
            this.debug(str);
        } else {
            this.print_err("ERROR, Null PrintWriter:  can not properly send back message: " + str);
        }
    }

    public void print_err(String str) {
        System.err.println(str);
        this.debug(str);
    }

    public void debug(String str) {
        TestUtil.logMsg((String)str);
        System.out.println(str);
    }
}

