/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation;

import ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.TSLogRecord;
import ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.TSXMLFormatter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TSLogger
extends Logger {
    public static final String MESSAGE_PREFIX = "JPA_ALTERNATE_PROVIDER : ";
    public static final String LOG_NAME = "JPALog.xml";
    public static final String LOG_NAME_DEFAULT_PROPERTY = "log.file.location.defaulted";
    public static final DateFormat df = new SimpleDateFormat("dd-MM-yyyy'T'HH:mm:ss.SSS");
    private String contextId;
    private int levelValue = Level.INFO.intValue();
    private int offValue = Level.OFF.intValue();
    private String name;
    private String logFile;
    private static TSLogger logger;

    protected TSLogger(String name, String logFile) {
        super(name, null);
        this.name = name;
        this.levelValue = Level.INFO.intValue();
        this.logFile = logFile;
    }

    public static synchronized void clearLogger() {
        if (logger != null) {
            Handler handler = logger.getHandlers()[0];
            logger.removeHandler(handler);
            handler.close();
        }
        logger = null;
    }

    public String getLogFile() {
        return this.logFile;
    }

    private void setLogFile(String logFileLocation) {
        this.logFile = logFileLocation;
    }

    public void log(String msg) {
        this.log(Level.INFO, msg);
    }

    @Override
    public void log(Level level, String msg) {
        this.log(level, this.createDateTime(), MESSAGE_PREFIX + msg, "JPA");
    }

    public void log(Level level, String dateTime, String msg) {
        this.log(level, dateTime, MESSAGE_PREFIX + msg, "JPA");
    }

    public void log(Level level, String dateTime, String msg, String contextId) {
        if (level.intValue() < this.levelValue || this.levelValue == this.offValue) {
            return;
        }
        TSLogRecord lr = new TSLogRecord(level, dateTime, msg, contextId);
        this.log(lr);
    }

    public void log(TSLogRecord record) {
        Handler[] targets = logger.getHandlers();
        targets[0].publish(record);
    }

    public static TSLogger getInstance() {
        if (logger == null) {
            try {
                String logFileLocation = TSLogger.validateOrCreateLogFileLocation();
                System.out.println("JPA_ALTERNATE_PROVIDER log:" + logFileLocation);
                logger = new TSLogger("JPA", logFileLocation);
                logger.setUseParentHandlers(false);
                FileHandler fileHandler = new FileHandler(logFileLocation, false);
                fileHandler.setFormatter(new TSXMLFormatter());
                logger.addHandler(fileHandler);
            }
            catch (Exception e) {
                throw new RuntimeException("TSLogger Initialization failed", e);
            }
        }
        return logger;
    }

    private static String validateOrCreateLogFileLocation() throws IOException {
        String logFileLocation = System.getProperty("log.file.location");
        if (logFileLocation == null) {
            System.out.println("JPA_ALTERNATE_PROVIDER log.file.location not set, will create tmp location.\nThe log.file.location needs to be set as system property on the test container.");
            Path tmpPath = Files.createTempFile("JPALog.", ".xml", new FileAttribute[0]);
            tmpPath.toFile().deleteOnExit();
            logFileLocation = tmpPath.toAbsolutePath().toString();
            System.setProperty(LOG_NAME_DEFAULT_PROPERTY, logFileLocation);
            System.out.println("JPA_ALTERNATE_PROVIDER tmp log.file.location:" + logFileLocation);
            return logFileLocation;
        }
        if (logFileLocation.endsWith("/")) {
            logFileLocation = logFileLocation.substring(0, logFileLocation.length() - 1);
        }
        System.out.println("JPA_ALTERNATE_PROVIDER log.file.location:" + logFileLocation);
        File dir = new File(logFileLocation);
        if (!dir.exists()) {
            System.out.println("Log directory does not exist, creating it.");
            if (!dir.mkdirs()) {
                throw new IOException("Failed to create log directory: " + logFileLocation);
            }
        }
        if (!dir.isDirectory()) {
            throw new IOException("Log directory is not a directory: " + logFileLocation);
        }
        String[] chld = dir.list();
        System.out.println("Searching for previous log files to delete");
        for (String fileName : chld) {
            File file;
            if (!fileName.contains(LOG_NAME) || !(file = new File(logFileLocation + "/" + fileName)).exists()) continue;
            System.out.println("Deleting JPA logfile:" + file.getName());
            file.delete();
        }
        return logFileLocation + "/JPALog.xml";
    }

    public String createDateTime() {
        return df.format(new Date());
    }
}

