/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.orderby;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.orderby.Address;
import ee.jakarta.tck.persistence.core.annotations.orderby.Address2;
import ee.jakarta.tck.persistence.core.annotations.orderby.Department;
import ee.jakarta.tck.persistence.core.annotations.orderby.Employee;
import ee.jakarta.tck.persistence.core.annotations.orderby.Insurance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class Client1
extends PMClientBase {
    List<Address> addrRef;
    Address addr1 = null;
    Address addr2 = null;
    Address addr3 = null;
    List<Address2> addrRef2;
    Address2 addr11 = null;
    Address2 addr12 = null;
    Address2 addr13 = null;

    public static void main(String[] args) {
        Client1 theTests = new Client1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderByTest1() throws Exception {
        this.logTrace("Begin orderByTest1");
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<String> resultsList = new ArrayList<String>();
        Object[] expectedResult = new String[]{"Zoe", "Song", "Jie", "Ay"};
        try {
            this.getEntityTransaction().begin();
            Employee empChange = (Employee)this.getEntityManager().find(Employee.class, (Object)65);
            empChange.setFirstName("Ay");
            this.getEntityManager().merge((Object)empChange);
            this.getEntityManager().flush();
            Insurance newIns = (Insurance)this.getEntityManager().find(Insurance.class, (Object)60);
            this.getEntityManager().refresh((Object)newIns);
            List<Employee> insResult = newIns.getEmployees();
            if (insResult.size() != 4) {
                this.logTrace("orderByTest1:  Did not get expected results.  Expected: 4, got: " + insResult.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<Employee> i1 = insResult.iterator();
                this.logTrace("Check Employee Collection for expected first names");
                while (i1.hasNext()) {
                    Employee e1 = i1.next();
                    resultsList.add(e1.getFirstName());
                    this.logTrace("orderByTest1: got Employee FirstName:" + e1.getFirstName());
                }
                this.logTrace("Compare first names received with expected first names ");
                Object[] result = resultsList.toArray(new String[resultsList.size()]);
                pass2 = Arrays.equals(expectedResult, result);
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass2 = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("orderByTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderByTest2() throws Exception {
        this.logTrace("Begin orderByTest2");
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<String> resultsList = new ArrayList<String>();
        Object[] expectedResult = new String[]{"Jie", "Song", "Yay", "Zoe"};
        try {
            this.getEntityTransaction().begin();
            Employee emp2Change = (Employee)this.getEntityManager().find(Employee.class, (Object)65);
            emp2Change.setFirstName("Yay");
            this.getEntityManager().merge((Object)emp2Change);
            this.getEntityManager().flush();
            Department newDept = (Department)this.getEntityManager().find(Department.class, (Object)50);
            this.getEntityManager().refresh((Object)newDept);
            List<Employee> deptResult = newDept.getEmployees();
            if (deptResult.size() != 4) {
                this.logTrace("orderByTest2:  Did not get expected results.  Expected: 4, got: " + deptResult.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<Employee> i2 = deptResult.iterator();
                this.logTrace("Check Employee Collection for expected first names");
                while (i2.hasNext()) {
                    Employee e2 = i2.next();
                    resultsList.add(e2.getFirstName());
                    this.logTrace("orderByTest2: got Employee FirstName:" + e2.getFirstName());
                }
                this.logTrace("Compare first names received with expected first names ");
                Object[] result = resultsList.toArray(new String[resultsList.size()]);
                pass2 = Arrays.equals(expectedResult, result);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("orderByTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderByTest3() throws Exception {
        this.logTrace("Begin orderByTest3");
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<String> resultsList = new ArrayList<String>();
        Object[] expectedResult = new String[]{"Zoe", "Song", "Penelope", "May", "Jie"};
        try {
            this.getEntityTransaction().begin();
            Employee emp3Change = (Employee)this.getEntityManager().find(Employee.class, (Object)85);
            Insurance ins = (Insurance)this.getEntityManager().find(Insurance.class, (Object)60);
            emp3Change.setInsurance(ins);
            this.getEntityManager().merge((Object)emp3Change);
            ins.getEmployees().add(emp3Change);
            this.getEntityManager().merge((Object)ins);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)ins);
            List<Employee> insResult = ins.getEmployees();
            if (insResult.size() != 5) {
                this.logErr("orderByTest3: Expected List Size of 5 got: " + insResult.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<Employee> i3 = insResult.iterator();
                this.logTrace("Check Employee Collection for expected first names");
                while (i3.hasNext()) {
                    Employee e3 = i3.next();
                    resultsList.add(e3.getFirstName());
                    this.logTrace("orderByTest3: got Employee FirstName:" + e3.getFirstName());
                }
                this.logTrace("orderByTest3: Expected size received, check ordering . . .");
                Object[] result = resultsList.toArray(new String[resultsList.size()]);
                pass2 = Arrays.equals(expectedResult, result);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("orderByTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderByTest4() throws Exception {
        this.logTrace("Begin orderByTest4");
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<String> resultsList = new ArrayList<String>();
        Object[] expectedResult = new String[]{"Jie", "May", "Penelope", "Song", "Zoe"};
        try {
            this.getEntityTransaction().begin();
            Employee emp4Change = (Employee)this.getEntityManager().find(Employee.class, (Object)85);
            Department dept = (Department)this.getEntityManager().find(Department.class, (Object)50);
            emp4Change.setDepartment(dept);
            this.getEntityManager().merge((Object)emp4Change);
            dept.getEmployees().add(emp4Change);
            this.getEntityManager().merge((Object)dept);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)dept);
            List<Employee> deptResult = dept.getEmployees();
            if (deptResult.size() != 5) {
                this.logErr("orderByTest4: Expected Collection Size of 5 got: " + deptResult.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<Employee> i4 = deptResult.iterator();
                this.logTrace("Check Employee Collection for expected first names");
                while (i4.hasNext()) {
                    Employee e4 = i4.next();
                    resultsList.add(e4.getFirstName());
                    this.logTrace("orderByTest4: got Employee FirstName:" + e4.getFirstName());
                }
                this.logTrace("orderByTest4: Expected size received, check ordering . . .");
                Object[] result = resultsList.toArray(new String[resultsList.size()]);
                pass2 = Arrays.equals(expectedResult, result);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("orderByTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        try {
            this.logTrace("createTestData");
            this.getEntityTransaction().begin();
            float salary = 10000.0f;
            Department d1 = new Department(50, "SJSAS Appserver");
            this.getEntityManager().persist((Object)d1);
            Insurance s1 = new Insurance(60, "United");
            this.getEntityManager().persist((Object)s1);
            Employee e1 = new Employee(70, "Jie", "Leng", 10000.0f, d1, s1);
            Employee e2 = new Employee(80, "Zoe", "Leng", 10000.0f, d1, s1);
            Employee e3 = new Employee(90, "Song", "Leng", 10000.0f, d1, s1);
            Employee e4 = new Employee(65, "May", "Leng", 10000.0f, d1, s1);
            Employee e5 = new Employee(85, "Penelope", "Leng", 10000.0f);
            this.getEntityManager().persist((Object)e1);
            this.getEntityManager().persist((Object)e2);
            this.getEntityManager().persist((Object)e3);
            this.getEntityManager().persist((Object)e4);
            this.getEntityManager().persist((Object)e5);
            ArrayList<Employee> link = new ArrayList<Employee>();
            link.add(e1);
            link.add(e2);
            link.add(e3);
            link.add(e4);
            d1.setEmployees(link);
            this.getEntityManager().merge((Object)d1);
            s1.setEmployees(link);
            this.getEntityManager().merge((Object)s1);
            this.logTrace("persisted Entity Data");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception creating test data:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from INSURANCE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

