/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.persist.basic;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.persist.basic.A;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest1() throws Exception {
        this.logTrace("Begin persistBasicTest1");
        boolean pass = false;
        try {
            A aRef = new A("1", "A1", 1);
            this.getEntityTransaction().begin();
            if (!this.getInstanceStatus(aRef)) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest2() throws Exception {
        this.logTrace("Begin persistBasicTest2");
        boolean pass = false;
        try {
            this.logTrace("new A");
            A aRef = new A("2", "a2", 2);
            this.createA(aRef);
            A newA = this.findA("2");
            if (newA != null) {
                this.logTrace("A IS NOT NULL");
            }
            this.getEntityTransaction().begin();
            pass = this.getInstanceStatus(this.findA("2"));
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest3() throws Exception {
        this.logTrace("Begin persistBasicTest3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("3", "a3", 3);
            this.logTrace("Persist Instance");
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().flush();
            this.logTrace("find By Name");
            A result = (A)this.findByName("a3");
            this.logTrace("Check to see that the entities are identical");
            if (result == a1) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back transaction", fe);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest4() throws Exception {
        this.logTrace("Begin persistBasicTest4");
        A aRef = new A("4", "a4", 4);
        boolean pass = false;
        try {
            this.logTrace("Persist Instance");
            this.createA(aRef);
            this.getEntityTransaction().begin();
            this.logTrace("get Instance Status ");
            if (this.getInstanceStatus(this.findA("4"))) {
                try {
                    this.logTrace("entity is managed, try to persist again ");
                    A newA = this.findA("4");
                    this.getEntityManager().persist((Object)newA);
                    this.logTrace("Persist ignored on an already persisted entity as expected");
                    pass = true;
                }
                catch (Exception ee) {
                    this.logErr("Unexpected exception trying to persist an already persisted entity", ee);
                    pass = false;
                }
            } else {
                this.logTrace("Instance is not managed. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected exception rolling back transaction", re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest5() throws Exception {
        this.logTrace("Begin persistBasicTest5");
        A aRef = new A("5", "a5", 5);
        boolean pass = false;
        try {
            this.logTrace("Persist Instance");
            this.createA(aRef);
            this.getEntityTransaction().begin();
            this.logTrace("get Instance Status ");
            if (this.getInstanceStatus(this.findA("5"))) {
                try {
                    this.logTrace("entity is managed, try to change name and flush ");
                    A a2 = this.findA("5");
                    a2.setAName("a2");
                    this.getEntityManager().flush();
                    if (a2.getAName().equals("a2")) {
                        this.logTrace("sync to database successful");
                        pass = true;
                    }
                }
                catch (Exception ee) {
                    this.logErr("Unexpected exception trying to flush apersisted entity", ee);
                    pass = false;
                }
            } else {
                this.logTrace("Instance is not already persisted. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected exception rolling back transaction", re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest5 failed");
        }
    }

    private void createA(A a) {
        this.logTrace("Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityManager().flush();
        this.getEntityTransaction().commit();
    }

    private A findA(String id) {
        this.logTrace("Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private Object findByName(String name) {
        this.logTrace("Entered findByName method");
        return this.getEntityManager().createQuery("select a from A a where a.name = :name").setParameter("name", (Object)name).getSingleResult();
    }

    private boolean getInstanceStatus(Object o) {
        this.logTrace("Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

