/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.callbacklistener;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.override.callbacklistener.OverridenCallBack;
import ee.jakarta.tck.persistence.core.override.util.CallBackCounts;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void postLoad() throws Exception {
        boolean pass3 = false;
        Long ID = 1L;
        CallBackCounts.clearCountsMap();
        OverridenCallBack entity = new OverridenCallBack();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        this.getEntityManager().flush();
        this.getEntityManager().refresh((Object)entity);
        this.getEntityManager().remove((Object)entity);
        this.getEntityTransaction().commit();
        this.logTrace("persisted entity" + entity);
        try {
            pass3 = this.checkLoadCallBacks();
            if (!pass3) {
                throw new Exception("Test failed while testing postLoad method");
            }
            this.logTrace("testOverrideCallBackMethods Passed");
        }
        catch (Exception e) {
            throw new Exception("Exception thrown while testing postLoad" + e);
        }
    }

    public void preAndPostPersist() throws Exception {
        boolean pass1 = false;
        Long ID = 1L;
        CallBackCounts.clearCountsMap();
        OverridenCallBack entity = new OverridenCallBack();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        this.getEntityManager().flush();
        this.getEntityManager().remove((Object)entity);
        this.getEntityTransaction().commit();
        this.logTrace("persisted entity" + entity);
        try {
            pass1 = this.checkPersistCallBacks();
            if (!pass1) {
                throw new Exception("Test failed while testing prepersist and postpersist methods");
            }
            this.logTrace("testOverrideCallBackMethods Passed");
        }
        catch (Exception e) {
            throw new Exception("Exception thrown while testing preAndPostPersist" + e);
        }
    }

    public void preAndPostRemove() throws Exception {
        boolean pass2 = false;
        Long ID = 1L;
        CallBackCounts.clearCountsMap();
        OverridenCallBack entity = new OverridenCallBack();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        this.getEntityManager().flush();
        this.getEntityManager().remove((Object)entity);
        this.getEntityManager().flush();
        this.getEntityTransaction().commit();
        this.logTrace("persisted entity" + entity);
        try {
            pass2 = this.checkRemoveCallBacks();
            if (!pass2) {
                throw new Exception("Test failed while testing preremove and postremove methods");
            }
            this.logTrace("testOverrideCallBackMethods Passed");
        }
        catch (Exception e) {
            throw new Exception("Exception thrown while testing preAndPostRemove" + e);
        }
    }

    private boolean checkPersistCallBacks() throws Exception {
        boolean result = false;
        if (this.test("prePersistFromXML", 1) && this.test("postPersistFromXML", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkRemoveCallBacks() throws Exception {
        boolean result = false;
        if (this.test("preRemoveFromXML", 1) && this.test("postRemoveFromXML", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkLoadCallBacks() throws Exception {
        boolean result = false;
        if (this.test("postLoadFromXML", 1)) {
            result = true;
        }
        return result;
    }

    private boolean test(String callBackName, int expectedCount) throws Exception {
        String thisTestId = callBackName;
        boolean pass = false;
        int count = CallBackCounts.getCount(callBackName);
        if (count == expectedCount) {
            this.logTrace("test passed in test method" + thisTestId);
            pass = true;
        } else {
            this.logErr("test failed in test method" + thisTestId);
            this.logTrace("in CallBackName =" + callBackName);
            this.logTrace("in expectedCount =" + expectedCount);
            this.logTrace("in ActualCount =" + count);
        }
        return pass;
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM NOENTITYLISTENER_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

