/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.spec.core.conditional.cwo;

import com.sun.ts.tests.jstl.common.client.AbstractUrlClient;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@Tags(value={@Tag(value="jstl"), @Tag(value="platform"), @Tag(value="web")})
@ExtendWith(value={ArquillianExtension.class})
public class JSTLClientIT
extends AbstractUrlClient {
    public static String packagePath = JSTLClientIT.class.getPackageName().replace(".", "/");

    public JSTLClientIT() throws Exception {
        this.setContextRoot("/jstl_core_cond_cwo_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jstl_core_cond_cwo_web.war");
        archive.setWebXML(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/jstl_core_cond_cwo_web.xml"));
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeCWONoWhenActionsTest.jsp")), "negativeCWONoWhenActionsTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeCWOOtherwiseExcBodyContentTest.jsp")), "negativeCWOOtherwiseExcBodyContentTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeCWOOtherwiseNoParentTest.jsp")), "negativeCWOOtherwiseNoParentTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeCWOWhenBeforeOtherwiseTest.jsp")), "negativeCWOWhenBeforeOtherwiseTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeCWOWhenExcBodyContentTest.jsp")), "negativeCWOWhenExcBodyContentTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeCWOWhenNoParentTest.jsp")), "negativeCWOWhenNoParentTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeCWOWhenTestReqAttrTest.jsp")), "negativeCWOWhenTestReqAttrTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeCWOWhenTypeTest.jsp")), "negativeCWOWhenTypeTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveCWOTest.jsp")), "positiveCWOTest.jsp");
        archive.addAsLibrary((Archive)JSTLClientIT.getCommonJarArchive());
        return archive;
    }

    @Test
    public void positiveCWOTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveCWOTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveCWOTest");
        this.invoke();
    }

    @Test
    public void negativeCWOWhenTypeTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/negativeCWOWhenTypeTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "negativeCWOWhenTypeTest");
        this.invoke();
    }

    @Test
    public void negativeCWOWhenExcBodyContentTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/negativeCWOWhenExcBodyContentTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "negativeCWOWhenExcBodyContentTest");
        this.invoke();
    }

    @Test
    public void negativeCWOOtherwiseExcBodyContentTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/negativeCWOOtherwiseExcBodyContentTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "negativeCWOOtherwiseExcBodyContentTest");
        this.invoke();
    }

    @Test
    public void negativeCWONoWhenActionsTest() throws Exception {
        TEST_PROPS.setProperty("testname", "negativeCWONoWhenActionsTest");
        TEST_PROPS.setProperty("request", "negativeCWONoWhenActionsTest.jsp");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeCWOWhenBeforeOtherwiseTest() throws Exception {
        TEST_PROPS.setProperty("testname", "negativeCWOWhenBeforeOtherwiseTest");
        TEST_PROPS.setProperty("request", "negativeCWOWhenBeforeOtherwiseTest.jsp");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeCWOWhenNoParentTest() throws Exception {
        TEST_PROPS.setProperty("testname", "negativeCWOWhenNoParentTest");
        TEST_PROPS.setProperty("request", "negativeCWOWhenNoParentTest.jsp");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeCWOOtherwiseNoParentTest() throws Exception {
        TEST_PROPS.setProperty("testname", "negativeCWOOtherwiseNoParentTest");
        TEST_PROPS.setProperty("request", "negativeCWOOtherwiseNoParentTest.jsp");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeCWOWhenTestReqAttrTest() throws Exception {
        TEST_PROPS.setProperty("testname", "negativeCWOWhenTestReqAttrTest");
        TEST_PROPS.setProperty("request", "negativeCWOWhenTestReqAttrTest.jsp");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }
}

