/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.id;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.id.FieldBigDecimalId;
import ee.jakarta.tck.persistence.core.annotations.id.FieldBigIntegerId;
import ee.jakarta.tck.persistence.core.annotations.id.FieldIntId;
import ee.jakarta.tck.persistence.core.annotations.id.FieldIntegerId;
import ee.jakarta.tck.persistence.core.annotations.id.FieldSQLDateId;
import ee.jakarta.tck.persistence.core.annotations.id.FieldStringId;
import ee.jakarta.tck.persistence.core.annotations.id.FieldUtilDateId;
import ee.jakarta.tck.persistence.core.annotations.id.PropertyBigDecimalId;
import ee.jakarta.tck.persistence.core.annotations.id.PropertyBigIntegerId;
import ee.jakarta.tck.persistence.core.annotations.id.PropertyIntId;
import ee.jakarta.tck.persistence.core.annotations.id.PropertyIntegerId;
import ee.jakarta.tck.persistence.core.annotations.id.PropertySQLDateId;
import ee.jakarta.tck.persistence.core.annotations.id.PropertyStringId;
import ee.jakarta.tck.persistence.core.annotations.id.PropertyUtilDateId;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    public void FieldIntegerIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Integer id = new Integer(1);
            FieldIntegerId expected = new FieldIntegerId(id, id);
            this.logTrace("Persisting IntegerId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            FieldIntegerId actual = (FieldIntegerId)this.getEntityManager().find(FieldIntegerId.class, (Object)id);
            if (actual != null) {
                if (actual.getIntegerData().equals(id)) {
                    this.logTrace("Received expected result:" + actual.getIntegerData());
                    pass = true;
                } else {
                    this.logErr("Expected Integer:" + id + ", actual: " + actual.getIntegerData());
                }
            } else {
                this.logErr("EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("FieldIntegerIdTest failed");
        }
    }

    public void FieldIntIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            int id = 1;
            FieldIntId expected = new FieldIntId(id, id);
            this.logTrace("Persisting IntId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            FieldIntId actual = (FieldIntId)this.getEntityManager().find(FieldIntId.class, (Object)id);
            if (actual != null) {
                if (actual.getIntData() == id) {
                    this.logTrace("Received expected result:" + actual.getIntData());
                    pass = true;
                } else {
                    this.logErr("Expected int:" + id + ", actual: " + actual.getIntData());
                }
            } else {
                this.logErr("EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("FieldIntIdTest failed");
        }
    }

    public void FieldBigIntegerIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BigInteger id = new BigInteger("1");
            FieldBigIntegerId expected = new FieldBigIntegerId(id, id);
            this.logTrace("Persisting BigIntegerId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            FieldBigIntegerId actual = (FieldBigIntegerId)this.getEntityManager().find(FieldBigIntegerId.class, (Object)id);
            if (actual != null) {
                if (actual.getBigInteger().equals(id)) {
                    this.logTrace("Received expected result:" + actual.getBigInteger());
                    pass = true;
                } else {
                    this.logErr("Expected name:" + id + ", actual: " + actual.getBigInteger());
                }
            } else {
                this.logErr("EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("FieldBigIntegerIdTest failed");
        }
    }

    public void FieldBigDecimalIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BigDecimal id = new BigDecimal(new BigInteger("1"));
            FieldBigDecimalId expected = new FieldBigDecimalId(id, id);
            this.logTrace("Persisting BigDecimalId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            FieldBigDecimalId actual = (FieldBigDecimalId)this.getEntityManager().find(FieldBigDecimalId.class, (Object)id);
            if (actual != null) {
                if (actual.getBigDecimal().equals(id)) {
                    this.logTrace("Received expected result:" + actual.getBigDecimal());
                    pass = true;
                } else {
                    this.logErr("Expected value:" + id + ", actual: " + actual.getBigDecimal());
                }
            } else {
                this.logErr("EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("FieldBigDecimalIdTest failed");
        }
    }

    public void FieldStringIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            String id = "1";
            FieldStringId expected = new FieldStringId("1", "1");
            this.logTrace("Persisting StringId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            FieldStringId actual = (FieldStringId)this.getEntityManager().find(FieldStringId.class, (Object)"1");
            if (actual != null) {
                if (actual.getName().equals("1")) {
                    this.logTrace("Received expected result:" + actual.getName());
                    pass = true;
                } else {
                    this.logErr("Expected name:1, actual: " + actual.getName());
                }
            } else {
                this.logErr("EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("FieldStringIdTest failed");
        }
    }

    public void FieldSQLDateIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Date id = this.getSQLDate(2006, 4, 15);
            FieldSQLDateId expected = new FieldSQLDateId(id, id);
            this.logTrace("Persisting StringId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            FieldSQLDateId actual = (FieldSQLDateId)this.getEntityManager().find(FieldSQLDateId.class, (Object)id);
            if (actual != null) {
                if (actual.getDate().equals(id)) {
                    this.logTrace("Received expected result:" + actual.getDate());
                    pass = true;
                } else {
                    this.logErr("Expected name:" + id + ", actual: " + actual.getDate());
                }
            } else {
                this.logErr("EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("FieldSQLDateIdTest failed");
        }
    }

    public void FieldUtilDateIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            java.util.Date id = this.getPKDate(2006, 4, 15);
            FieldUtilDateId expected = new FieldUtilDateId(id, id);
            this.logTrace("Persisting StringId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            FieldUtilDateId actual = (FieldUtilDateId)this.getEntityManager().find(FieldUtilDateId.class, (Object)id);
            if (actual != null) {
                if (actual.getDate().equals(id)) {
                    this.logTrace("Received expected result:" + actual.getDate());
                    pass = true;
                } else {
                    this.logErr("Expected name:" + id + ", actual: " + actual.getDate());
                }
            } else {
                this.logErr("EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("FieldUtilDateIdTest failed");
        }
    }

    public void PropertyIntegerIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Integer id = new Integer(1);
            PropertyIntegerId expected = new PropertyIntegerId(id, id);
            this.logTrace("Persisting IntegerId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            PropertyIntegerId actual = (PropertyIntegerId)this.getEntityManager().find(PropertyIntegerId.class, (Object)id);
            if (actual != null) {
                if (actual.getIntegerData().equals(id)) {
                    this.logTrace("Received expected result:" + actual.getIntegerData());
                    pass = true;
                } else {
                    this.logErr("Expected Integer:" + id + ", actual: " + actual.getIntegerData());
                }
            } else {
                this.logErr("EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("PropertyIntegerIdTest failed");
        }
    }

    public void PropertyIntIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            int id = 1;
            PropertyIntId expected = new PropertyIntId(id, id);
            this.logTrace("Persisting IntId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            PropertyIntId actual = (PropertyIntId)this.getEntityManager().find(PropertyIntId.class, (Object)id);
            if (actual != null) {
                if (actual.getIntData() == id) {
                    this.logTrace("Received expected result:" + actual.getIntData());
                    pass = true;
                } else {
                    this.logErr("Expected int:" + id + ", actual: " + actual.getIntData());
                }
            } else {
                this.logErr("EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("PropertyIntIdTest failed");
        }
    }

    public void PropertyBigIntegerIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BigInteger id = new BigInteger("1");
            PropertyBigIntegerId expected = new PropertyBigIntegerId(id, id);
            this.logTrace("Persisting BigIntegerId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            PropertyBigIntegerId actual = (PropertyBigIntegerId)this.getEntityManager().find(PropertyBigIntegerId.class, (Object)id);
            if (actual != null) {
                if (actual.getBigInteger().equals(id)) {
                    this.logTrace("Received expected result:" + actual.getBigInteger());
                    pass = true;
                } else {
                    this.logErr("Expected name:" + id + ", actual: " + actual.getBigInteger());
                }
            } else {
                this.logErr("EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("PropertyBigIntegerIdTest failed");
        }
    }

    public void PropertyBigDecimalIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BigDecimal id = new BigDecimal(new BigInteger("1"));
            PropertyBigDecimalId expected = new PropertyBigDecimalId(id, id);
            this.logTrace("Persisting BigDecimalId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            PropertyBigDecimalId actual = (PropertyBigDecimalId)this.getEntityManager().find(PropertyBigDecimalId.class, (Object)id);
            if (actual != null) {
                if (actual.getBigDecimal().equals(id)) {
                    this.logTrace("Received expected result:" + actual.getBigDecimal());
                    pass = true;
                } else {
                    this.logErr("Expected value:" + id + ", actual: " + actual.getBigDecimal());
                }
            } else {
                this.logErr("EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("PropertyBigDecimalIdTest failed");
        }
    }

    public void PropertyStringIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            String id = "1";
            PropertyStringId expected = new PropertyStringId("1", "1");
            this.logTrace("Persisting StringId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            PropertyStringId actual = (PropertyStringId)this.getEntityManager().find(PropertyStringId.class, (Object)"1");
            if (actual != null) {
                if (actual.getName().equals("1")) {
                    this.logTrace("Received expected result:" + actual.getName());
                    pass = true;
                } else {
                    this.logErr("Expected name:1, actual: " + actual.getName());
                }
            } else {
                this.logErr("EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("PropertyStringIdTest failed");
        }
    }

    public void PropertySQLDateIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Date id = this.getSQLDate(2006, 4, 15);
            PropertySQLDateId expected = new PropertySQLDateId(id, id);
            this.logTrace("Persisting StringId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            PropertySQLDateId actual = (PropertySQLDateId)this.getEntityManager().find(PropertySQLDateId.class, (Object)id);
            if (actual != null) {
                if (actual.getDate().equals(id)) {
                    this.logTrace("Received expected result:" + actual.getDate());
                    pass = true;
                } else {
                    this.logErr("Expected name:" + id + ", actual: " + actual.getDate());
                }
            } else {
                this.logErr("EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("PropertySQLDateIdTest failed");
        }
    }

    public void PropertyUtilDateIdTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            java.util.Date id = this.getPKDate(2006, 4, 15);
            PropertyUtilDateId expected = new PropertyUtilDateId(id, id);
            this.logTrace("Persisting StringId");
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            PropertyUtilDateId actual = (PropertyUtilDateId)this.getEntityManager().find(PropertyUtilDateId.class, (Object)id);
            if (actual != null) {
                if (actual.getDate().equals(id)) {
                    this.logTrace("Received expected result:" + actual.getDate());
                    pass = true;
                } else {
                    this.logErr("Expected name:" + id + ", actual: " + actual.getDate());
                }
            } else {
                this.logErr("EntityManager.find returned null result");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("PropertyUtilDateIdTest failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM A_BASIC").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES2").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES3").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

