/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManagerFactoryCloseExceptions;

import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import jakarta.persistence.EntityManagerFactory;
import java.util.HashMap;
import java.util.Properties;

public class Client
extends PMClientBase {
    Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void cleanup() throws Exception {
        super.cleanup();
    }

    public void nullCleanup() throws Exception {
    }

    @CleanupMethod(name="nullCleanup")
    public void exceptionsTest() throws Exception {
        int passCount = 0;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        this.logMsg("Getting EntityManagerFactory");
        EntityManagerFactory emf = this.isStandAloneMode() ? this.getEntityManager().getEntityManagerFactory() : this.getEntityManagerFactory();
        if (emf != null) {
            if (emf.isOpen()) {
                this.logMsg("EMF is open, now closing it");
                emf.close();
            } else {
                this.logMsg("EMF is already closed");
            }
            this.logMsg("Testing getMetamodel() after close");
            try {
                emf.getMetamodel();
                this.logErr("IllegalStateException not thrown");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Received expected IllegalStateException");
                ++passCount;
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
            }
            this.logMsg("Testing emf.getProperties()");
            try {
                emf.getProperties();
                this.logErr("IllegalStateException not thrown");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Received expected IllegalStateException");
                ++passCount;
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
            }
            this.logMsg("Testing getPersistenceUnitUtil() after close");
            try {
                emf.getPersistenceUnitUtil();
                this.logErr("Did no throw IllegalStateException");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Received expected IllegalStateException");
                ++passCount;
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
            }
            this.logMsg("Testing close after close ");
            try {
                emf.close();
                this.logErr("IllegalStateException not thrown");
            }
            catch (IllegalStateException e) {
                this.logTrace("IllegalStateException Caught as Expected.");
                ++passCount;
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
            }
            this.logMsg("Testing createEntityManager() after close");
            try {
                emf.createEntityManager();
                this.logErr("IllegalStateException not thrown");
            }
            catch (IllegalStateException e) {
                this.logTrace("IllegalStateException Caught as Expected.");
                ++passCount;
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
            }
            this.logMsg("Testing createEntityManager(Map) after close");
            try {
                emf.createEntityManager(myMap);
                this.logErr("IllegalStateException not thrown");
            }
            catch (IllegalStateException e) {
                this.logTrace("IllegalStateException Caught as Expected.");
                ++passCount;
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
            }
            this.logMsg("Testing getCache after close ");
            try {
                emf.getCache();
                this.logErr("IllegalStateException not thrown");
            }
            catch (IllegalStateException e) {
                this.logTrace("IllegalStateException Caught as Expected.");
                ++passCount;
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
            }
            try {
                emf.getCriteriaBuilder();
                this.logErr("IllegalStateException was not thrown");
            }
            catch (IllegalStateException ise) {
                ++passCount;
                this.logTrace("Received expected IllegalStateException");
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
            }
        } else {
            this.logErr("Could not obtain an EntityManagerFactory");
        }
        if (passCount != 8) {
            throw new Exception("exceptionsTest failed");
        }
    }
}

