/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.session.stateful.cm.allowed;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.ejb30.bb.session.stateful.cm.allowed.SetRollbackOnlyIF;
import com.sun.ts.tests.ejb30.common.allowed.AllowedIF;
import com.sun.ts.tests.ejb30.common.allowed.CallbackAllowedIF;
import com.sun.ts.tests.ejb30.common.allowed.ClientBase;
import com.sun.ts.tests.ejb30.common.allowed.Constants;
import com.sun.ts.tests.ejb30.common.allowed.NoTxAllowedIF;
import com.sun.ts.tests.ejb30.common.allowed.SessionContextAllowedIF;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBException;
import java.util.Properties;

public class Client
extends ClientBase
implements Constants {
    @EJB(name="ejb/allowedBean", beanName="AllowedBean")
    private static AllowedIF allowedBean;
    @EJB(name="ejb/callbackAllowedBean", beanName="CallbackAllowedBean")
    private static CallbackAllowedIF callbackAllowedBean;
    @EJB(name="ejb/sessionContextAllowedBean", beanName="SessionContextAllowedBean")
    private static SessionContextAllowedIF sessionContextAllowedBean;
    @EJB(name="ejb/NoTxAllowedBean")
    private static NoTxAllowedIF noTxAllowedBean;
    @EJB(name="ejb/SetRollbackOnlyBean")
    private static SetRollbackOnlyIF setRollbackOnlyBean;
    @EJB(name="ejb/injectionAllowedBean", beanName="InjectionAllowedBean")
    private static SessionContextAllowedIF injectionAllowedBean;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void cleanup() throws EETest.Fault {
        this.remove();
    }

    @Override
    protected void remove() {
        super.remove();
        if (noTxAllowedBean != null) {
            try {
                noTxAllowedBean.remove();
                TLogger.log("noTxAllowed removed successfully.");
            }
            catch (Exception e) {
                TLogger.log("failed to remove noTxAllowed.");
            }
        }
        if (setRollbackOnlyBean != null) {
            try {
                setRollbackOnlyBean.remove();
                TLogger.log("setRollbackOnlyBean removed successfully.");
            }
            catch (Exception e) {
                TLogger.log("failed to remove setRollbackOnlyBean.");
            }
        }
    }

    public void postConstructTest() throws Exception {
        Properties results = null;
        Properties expected = new Properties();
        expected.setProperty("getEJBHome", "disallowed");
        expected.setProperty("getCallerPrincipal", "allowed");
        expected.setProperty("isCallerInRole", "allowed");
        expected.setProperty("getEJBObject", "disallowed");
        expected.setProperty("JNDI_Access", "allowed");
        expected.setProperty("UserTransaction", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test1", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test2", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test3", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test4", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test5", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test6", "disallowed");
        expected.setProperty("getEJBLocalHome", "disallowed");
        expected.setProperty("getEJBLocalObject", "disallowed");
        expected.setProperty("getBusinessObject", "allowed");
        try {
            callbackAllowedBean = this.lookupCallbackAllowedBean();
            results = callbackAllowedBean.getResults();
        }
        catch (Exception e) {
            throw new Exception("postConstructTest failed", e);
        }
        this.checkResults(results, expected);
    }

    public void setSessionContextTest() throws Exception {
        Properties results = null;
        Properties expected = new Properties();
        expected.setProperty("getEJBHome", "disallowed");
        expected.setProperty("getCallerPrincipal", "disallowed");
        expected.setProperty("isCallerInRole", "disallowed");
        expected.setProperty("getEJBObject", "disallowed");
        expected.setProperty("JNDI_Access", "allowed");
        expected.setProperty("UserTransaction", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test1", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test2", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test3", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test4", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test5", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test6", "disallowed");
        expected.setProperty("getEJBLocalHome", "disallowed");
        expected.setProperty("getEJBLocalObject", "disallowed");
        expected.setProperty("Timer_Methods", "disallowed");
        try {
            sessionContextAllowedBean = this.lookupSessionContextAllowedBean();
            results = sessionContextAllowedBean.getResults();
        }
        catch (Exception e) {
            throw new Exception("setSessionContextTest failed", e);
        }
        this.checkResults(results, expected);
    }

    public void businessTest() throws Exception {
        Properties results = null;
        Properties expected = new Properties();
        expected.setProperty("getEJBHome", "disallowed");
        expected.setProperty("getCallerPrincipal", "allowed");
        expected.setProperty("getRollbackOnly", "allowed");
        expected.setProperty("isCallerInRole", "allowed");
        expected.setProperty("getEJBObject", "disallowed");
        expected.setProperty("JNDI_Access", "allowed");
        expected.setProperty("UserTransaction", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test1", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test2", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test3", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test4", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test5", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test6", "disallowed");
        expected.setProperty("getEJBLocalHome", "disallowed");
        expected.setProperty("getEJBLocalObject", "disallowed");
        expected.setProperty("Timer_Methods", "allowed");
        expected.setProperty("getBusinessObject", "allowed");
        try {
            allowedBean = this.lookupAllowedBean();
            results = allowedBean.business();
        }
        catch (Exception e) {
            throw new Exception("businessTest failed", e);
        }
        this.checkResults(results, expected);
    }

    public void preInvokeTest() throws Exception {
        Properties results = null;
        Properties expected = new Properties();
        expected.setProperty("getEJBHome", "disallowed");
        expected.setProperty("getCallerPrincipal", "allowed");
        expected.setProperty("getRollbackOnly", "allowed");
        expected.setProperty("isCallerInRole", "allowed");
        expected.setProperty("getEJBObject", "disallowed");
        expected.setProperty("JNDI_Access", "allowed");
        expected.setProperty("UserTransaction", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test1", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test2", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test3", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test4", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test5", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test6", "disallowed");
        expected.setProperty("getEJBLocalHome", "disallowed");
        expected.setProperty("getEJBLocalObject", "disallowed");
        expected.setProperty("Timer_Methods", "allowed");
        expected.setProperty("getBusinessObject", "allowed");
        try {
            allowedBean = this.lookupAllowedBean();
            results = allowedBean.preInvokeTest();
        }
        catch (Exception e) {
            throw new Exception("preInvokeTest failed", e);
        }
        this.checkResults(results, expected);
    }

    public void postInvokeTest() throws Exception {
        Properties results = null;
        Properties expected = new Properties();
        expected.setProperty("getEJBHome", "disallowed");
        expected.setProperty("getCallerPrincipal", "allowed");
        expected.setProperty("getRollbackOnly", "allowed");
        expected.setProperty("isCallerInRole", "allowed");
        expected.setProperty("getEJBObject", "disallowed");
        expected.setProperty("JNDI_Access", "allowed");
        expected.setProperty("UserTransaction", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test1", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test2", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test3", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test4", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test5", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test6", "disallowed");
        expected.setProperty("getEJBLocalHome", "disallowed");
        expected.setProperty("getEJBLocalObject", "disallowed");
        expected.setProperty("Timer_Methods", "allowed");
        expected.setProperty("getBusinessObject", "allowed");
        try {
            allowedBean = this.lookupAllowedBean();
            allowedBean.postInvokeTest();
            results = allowedBean.getResultsPostInvoke();
        }
        catch (Exception e) {
            throw new Exception("postInvokeTest failed", e);
        }
        this.checkResults(results, expected);
    }

    public void afterBeginTest() throws Exception {
        Properties results = null;
        Properties expected = new Properties();
        expected.setProperty("getEJBHome", "disallowed");
        expected.setProperty("getCallerPrincipal", "allowed");
        expected.setProperty("getRollbackOnly", "allowed");
        expected.setProperty("isCallerInRole", "allowed");
        expected.setProperty("getEJBObject", "disallowed");
        expected.setProperty("JNDI_Access", "allowed");
        expected.setProperty("UserTransaction", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test1", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test2", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test3", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test4", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test5", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test6", "disallowed");
        expected.setProperty("getEJBLocalHome", "disallowed");
        expected.setProperty("getEJBLocalObject", "disallowed");
        expected.setProperty("Timer_Methods", "allowed");
        expected.setProperty("getBusinessObject", "allowed");
        try {
            allowedBean = this.lookupAllowedBean();
            allowedBean.setTestMethod("afterBeginTest");
            results = allowedBean.afterBeginTest();
        }
        catch (Exception e) {
            throw new Exception("afterBeginTest failed", e);
        }
        this.checkResults(results, expected);
    }

    public void beforeCompletionTest() throws Exception {
        Properties results = null;
        Properties expected = new Properties();
        expected.setProperty("getEJBHome", "disallowed");
        expected.setProperty("getCallerPrincipal", "allowed");
        expected.setProperty("getRollbackOnly", "allowed");
        expected.setProperty("isCallerInRole", "allowed");
        expected.setProperty("getEJBObject", "disallowed");
        expected.setProperty("JNDI_Access", "allowed");
        expected.setProperty("UserTransaction", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test1", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test2", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test3", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test4", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test5", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test6", "disallowed");
        expected.setProperty("getEJBLocalHome", "disallowed");
        expected.setProperty("getEJBLocalObject", "disallowed");
        expected.setProperty("Timer_Methods", "allowed");
        expected.setProperty("getBusinessObject", "allowed");
        try {
            allowedBean = this.lookupAllowedBean();
            allowedBean.setTestMethod("beforeCompletionTest");
            results = allowedBean.beforeCompletionTest();
        }
        catch (Exception e) {
            throw new Exception("beforeCompletionTest failed", e);
        }
        this.checkResults(results, expected);
    }

    public void afterCompletionTest() throws Exception {
        Properties results = null;
        Properties expected = new Properties();
        expected.setProperty("getEJBHome", "disallowed");
        expected.setProperty("getCallerPrincipal", "allowed");
        expected.setProperty("getRollbackOnly", "disallowed");
        expected.setProperty("isCallerInRole", "allowed");
        expected.setProperty("getEJBObject", "disallowed");
        expected.setProperty("JNDI_Access", "allowed");
        expected.setProperty("UserTransaction", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test1", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test2", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test3", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test4", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test5", "disallowed");
        expected.setProperty("UserTransaction_Methods_Test6", "disallowed");
        expected.setProperty("getEJBLocalHome", "disallowed");
        expected.setProperty("getEJBLocalObject", "disallowed");
        expected.setProperty("getBusinessObject", "allowed");
        try {
            allowedBean = this.lookupAllowedBean();
            allowedBean.setTestMethod("afterCompletionTest");
            allowedBean.afterCompletionTest();
            results = allowedBean.getResultsAfterCompletion();
        }
        catch (Exception e) {
            throw new Exception("afterCompletionTest failed", e);
        }
        this.checkResults(results, expected);
    }

    public void txNotSupportedTest() throws Exception {
        try {
            noTxAllowedBean.txNotSupported();
        }
        catch (Exception e) {
            throw new Exception("txNotSupportedTest failed", e);
        }
    }

    public void txSupportsTest() throws Exception {
        try {
            noTxAllowedBean.txSupports();
        }
        catch (Exception e) {
            throw new Exception("txSupportsTest failed", e);
        }
    }

    public void txNeverTest() throws Exception {
        try {
            noTxAllowedBean.txNever();
        }
        catch (Exception e) {
            throw new Exception("txNeverTest failed", e);
        }
    }

    public void businessSetRollbackOnlyTest() throws Exception {
        String result = null;
        String expected = "allowed";
        String reason = null;
        try {
            setRollbackOnlyBean.setTestMethod("businessSetRollbackOnlyTest");
            setRollbackOnlyBean.businessSetRollbackOnlyTest();
            result = setRollbackOnlyBean.getResultFor("businessSetRollbackOnlyTest");
            if (!expected.equals(result)) {
                reason = "Expected " + expected + ", but got " + result;
                throw new Exception(reason);
            }
        }
        catch (Exception e) {
            reason = "Expected " + expected;
            throw new Exception(reason, e);
        }
    }

    public void afterBeginSetRollbackOnlyTest() throws Exception {
        String result = null;
        String expected = "allowed";
        String reason = null;
        try {
            setRollbackOnlyBean.setTestMethod("afterBeginSetRollbackOnlyTest");
            setRollbackOnlyBean.afterBeginSetRollbackOnlyTest();
            result = setRollbackOnlyBean.getResultFor("afterBeginSetRollbackOnlyTest");
            if (!expected.equals(result)) {
                reason = "Expected " + expected + ", but got " + result;
                throw new Exception(reason);
            }
        }
        catch (Exception e) {
            reason = "Expected " + expected;
            throw new Exception(reason, e);
        }
    }

    public void beforeCompletionSetRollbackOnlyTest() throws Exception {
        block3: {
            String result = null;
            String expected = "allowed";
            String reason = null;
            try {
                setRollbackOnlyBean.setTestMethod("beforeCompletionSetRollbackOnlyTest");
                setRollbackOnlyBean.beforeCompletionSetRollbackOnlyTest();
                result = setRollbackOnlyBean.getResultFor("beforeCompletionSetRollbackOnlyTest");
                if (!expected.equals(result)) {
                    reason = "Expected " + expected + ", but got " + result;
                    throw new Exception(reason);
                }
            }
            catch (EJBException e) {
                result = setRollbackOnlyBean.getResultFor("beforeCompletionSetRollbackOnlyTest");
                if (expected.equals(result)) break block3;
                reason = "Expected " + expected + ", but got " + result;
                throw new Exception(reason);
            }
        }
    }

    public void afterCompletionSetRollbackOnlyTest() throws Exception {
        String result = null;
        String expected = "disallowed";
        String reason = null;
        try {
            setRollbackOnlyBean.setTestMethod("afterCompletionSetRollbackOnlyTest");
            setRollbackOnlyBean.afterCompletionSetRollbackOnlyTest();
            result = setRollbackOnlyBean.getResultFor("afterCompletionSetRollbackOnlyTest");
            if (!expected.equals(result)) {
                reason = "Expected " + expected + ", but got " + result;
                throw new Exception(reason);
            }
        }
        catch (Exception e) {
            reason = "Expected " + expected;
            throw new Exception(reason, e);
        }
    }
}

